/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.template;

import com.narucy.webpub.core.template.TemplateParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class Template
implements Cloneable {
    public static final String NAME_CONTENTS = "CONTENTS";
    String name;
    ArrayList lines = new ArrayList();
    HashMap properties = new HashMap();

    public Template(String name) {
        this.name = name;
    }

    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(Object key) {
        return this.properties.get(key);
    }

    public Object[] getPropertyKeys() {
        return this.properties.keySet().toArray();
    }

    public Template[] getChildrenTemplates() {
        return this.getChildrenTemplates(null);
    }

    public Template[] getChildrenTemplates(String name) {
        ArrayList<Object> tmpls = new ArrayList<Object>();
        Object[] ls = this.lines.toArray();
        int i = 0;
        while (i < ls.length) {
            Object obj = ls[i];
            if (obj instanceof Template && (name == null || ((Template)obj).getName().equals(name))) {
                tmpls.add(obj);
            }
            ++i;
        }
        return tmpls.toArray(new Template[0]);
    }

    public void addTemplate(Template template) {
        this.lines.add(template);
    }

    public void addLine(String line) {
        this.lines.add(line);
    }

    public String[] getTemplateNames() {
        ArrayList<String> list = new ArrayList<String>();
        Template[] tmpls = this.getAllTemplates();
        int i = 0;
        while (i < tmpls.length) {
            String n = tmpls[i].getName();
            if (!list.contains(n)) {
                list.add(n);
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public String getJoinedLines() {
        String[] lines = this.getLines();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < lines.length) {
            buffer.append(lines[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public String[] getLines() {
        ArrayList lines = new ArrayList();
        this.createLines(lines);
        return lines.toArray(new String[lines.size()]);
    }

    void createLines(ArrayList list) {
        Object[] ls = this.lines.toArray();
        int i = 0;
        while (i < ls.length) {
            Object l = ls[i];
            if (l instanceof String) {
                list.add(l);
            } else if (l instanceof Template) {
                Template t = (Template)l;
                t.createLines(list);
            }
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public Template[] getAllTemplates() {
        return this.getAllTemplates(null);
    }

    public Template[] getAllTemplates(String name) {
        ArrayList list = new ArrayList();
        Template[] tmpls = this.getChildrenTemplates();
        int i = 0;
        while (i < tmpls.length) {
            Template.findTmpls(tmpls[i], list, name);
            ++i;
        }
        return list.toArray(new Template[list.size()]);
    }

    static void findTmpls(Template template, ArrayList list, String name) {
        if (name == null || template.getName().equals(name)) {
            list.add(template);
        }
        Template[] tmpls = template.getChildrenTemplates();
        int i = 0;
        while (i < tmpls.length) {
            Template.findTmpls(tmpls[i], list, name);
            ++i;
        }
    }

    public Template[] getInvalidTemplates() {
        ArrayList<Template> list = new ArrayList<Template>();
        Template[] tmpls = this.getAllTemplates();
        int i = 0;
        while (i < tmpls.length) {
            Template t1 = tmpls[i];
            int j = i + 1;
            while (j < tmpls.length) {
                Template t2 = tmpls[j];
                if (!list.contains(t2) && t1.getName().equals(t2.getName()) && !t1.equals(t2)) {
                    list.add(t2);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new Template[list.size()]);
    }

    boolean hasTemplate(String n) {
        String[] names = this.getTemplateNames();
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(n)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void modifyTmpl(Template newTmpl) throws TemplateParseException {
        String newTmplName = newTmpl.getName();
        if (newTmplName.equals(NAME_CONTENTS)) {
            throw new IllegalArgumentException("Invalid template type:CONTENTS");
        }
        Template[] childs = newTmpl.getChildrenTemplates();
        int i = 0;
        while (i < childs.length) {
            Template t = childs[i];
            if (!t.getName().equals(NAME_CONTENTS)) {
                this.modifyTmpl(t);
            }
            ++i;
        }
        HashMap<String, Integer> replaceTargetFlags = new HashMap<String, Integer>();
        Template[] origTmpls = this.getChildrenTemplates();
        int i2 = 0;
        while (i2 < origTmpls.length) {
            replaceTargetFlags.clear();
            Template origTmpl = origTmpls[i2];
            String origTmplName = origTmpl.getName();
            if (!origTmplName.equals(NAME_CONTENTS)) {
                origTmpl.modifyTmpl(newTmpl);
                if (origTmplName.equals(newTmplName)) {
                    Template editTemplate = new Template(newTmplName);
                    Object[] lineObjs = newTmpl.lines.toArray();
                    int j = 0;
                    while (j < lineObjs.length) {
                        Object o = lineObjs[j];
                        if (o instanceof String) {
                            editTemplate.addLine((String)o);
                        } else if (o instanceof Template) {
                            Template childTmpl = (Template)o;
                            String childTmplName = childTmpl.getName();
                            int index = replaceTargetFlags.containsKey(childTmplName) ? (Integer)replaceTargetFlags.get(childTmplName) + 1 : 0;
                            replaceTargetFlags.put(childTmplName, new Integer(index));
                            Template[] ts = origTmpl.getChildrenTemplates(childTmplName);
                            if (ts != null && ts.length > index) {
                                editTemplate.addTemplate(ts[index]);
                            } else {
                                Template t = new Template(childTmplName);
                                t.addLine("<!-- $begin:" + childTmplName + "$ -->\n");
                                t.addLine("<!-- $end:" + childTmplName + "$ -->\n");
                                editTemplate.addTemplate(t);
                            }
                        }
                        ++j;
                    }
                    int index = this.lines.indexOf(origTmpl);
                    this.lines.remove(index);
                    this.lines.add(index, editTemplate);
                }
            }
            ++i2;
        }
    }

    public boolean equals(Object obj) {
        Object[] otherLs;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Template)) {
            return false;
        }
        Template other = (Template)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.name.equals(NAME_CONTENTS)) {
            return true;
        }
        Object[] ls = this.lines.toArray();
        if (ls.length != (otherLs = other.lines.toArray()).length) {
            return false;
        }
        int i = 0;
        while (i < ls.length) {
            if (!ls[i].equals(otherLs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object clone() {
        Template tmpl = new Template(this.name);
        Object[] ls = this.lines.toArray();
        int i = 0;
        while (i < ls.length) {
            Object o = ls[i];
            if (o instanceof String) {
                tmpl.lines.add(o);
            } else if (o instanceof Template) {
                tmpl.lines.add(((Template)o).clone());
            }
            ++i;
        }
        tmpl.properties = (HashMap)this.properties.clone();
        return tmpl;
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }
}

