/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.publish;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SourceFileSeeker {
    static DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    IFile publishFile;
    WebProject webProject = null;

    public SourceFileSeeker(String url) throws CoreException {
        this(SourceFileSeeker.toURL(url));
    }

    static URL toURL(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                url = new File(urlStr).toURL();
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        return url;
    }

    public SourceFileSeeker(URL url) throws CoreException {
        this(url != null ? SourceFileSeeker.urlToFile(url) : null);
    }

    static IFile urlToFile(URL url) throws CoreException {
        Path path = new Path(new File(url.getFile()).toString());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        if (file != null && file.isAccessible()) {
            return file;
        }
        String urlStr = url.toString();
        WebProject[] wps = SourceFileSeeker.getWebProjects();
        int i = 0;
        while (i < wps.length) {
            WebProject wp = wps[i];
            String[] urls = wp.getArray("mapped_url");
            int j = 0;
            while (j < urls.length) {
                String u = urls[j];
                if (urlStr.toLowerCase().startsWith(u.toLowerCase())) {
                    IFile f;
                    String relPath = urlStr.substring(u.length());
                    if (relPath.charAt(relPath.length() - 1) == '/') {
                        relPath = String.valueOf(relPath) + "index.html";
                    }
                    if ((f = wp.getFolder("publish_folder").getFile((IPath)new Path(relPath))) != null && f.isAccessible()) {
                        return f;
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    static WebProject[] getWebProjects() throws CoreException {
        ArrayList<WebProject> dist = new ArrayList<WebProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            WebProject wp;
            IProject project = projects[i];
            if (project.isAccessible() && (wp = (WebProject)project.getNature("com.narucy.webpub.core.publishNature")) != null) {
                dist.add(wp);
            }
            ++i;
        }
        return dist.toArray(new WebProject[dist.size()]);
    }

    public SourceFileSeeker(IFile publishFile) throws CoreException {
        this.publishFile = publishFile;
        if (publishFile != null) {
            WebProject[] wps = SourceFileSeeker.getWebProjects();
            int i = 0;
            while (i < wps.length) {
                WebProject wp = wps[i];
                if (wp.getFolder("publish_folder").getProject().equals((Object)publishFile.getProject()) && SourceFileSeeker.isParentFolder(publishFile, wp.getFolder("publish_folder"))) {
                    this.webProject = wp;
                    break;
                }
                ++i;
            }
        }
    }

    public IFile getPublishFrom() throws CoreException {
        if (this.webProject == null) {
            return null;
        }
        IContainer pubFolder = this.webProject.getFolder("publish_folder");
        if (pubFolder == null || !SourceFileSeeker.isParentFolder(this.publishFile, pubFolder)) {
            return null;
        }
        IContainer htFolder = this.webProject.getFolder("htsources_folder");
        IPath publishPath = pubFolder.getFullPath();
        IPath relPath = this.publishFile.getFullPath().removeFirstSegments(publishPath.segmentCount());
        IFile htSrc = htFolder.getFile(relPath);
        if (htSrc.exists()) {
            return htSrc;
        }
        return this.getPublishFromAsPublishDescriptions();
    }

    IFile getPublishFromAsPublishDescriptions() throws CoreException {
        try {
            IFile[] publishDescriptions = this.findPublishDescriptorFiles();
            this.sortPublishDescriptorFiles(publishDescriptions);
            int i = 0;
            while (i < publishDescriptions.length) {
                IFile pubDesc = publishDescriptions[i];
                IContainer fromBase = pubDesc.getParent();
                Object[][] pubDescEntries = SourceFileSeeker.getPublishDescriptionEntries(publishDescriptions[i]);
                int j = 0;
                while (j < pubDescEntries.length) {
                    IFile file;
                    String pattern = (String)pubDescEntries[j][0];
                    String pubTo = (String)pubDescEntries[j][1];
                    if (pubTo != null && (file = this.isPublishFileEntried(fromBase, pattern, pubTo, this.publishFile)) != null) {
                        return file;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (SAXException e) {
            WebpubPlugin.handleException(e);
        }
        catch (IOException e) {
            WebpubPlugin.handleException(e);
        }
        catch (ParserConfigurationException e) {
            WebpubPlugin.handleException(e);
        }
        return null;
    }

    IFile isPublishFileEntried(IContainer fromContainer, String pattern, String publishTo, IFile publishFile) throws CoreException {
        block8: {
            block9: {
                block7: {
                    IFile tobePublishedFile = this.webProject.getFolder("publish_folder").getFile((IPath)new Path(publishTo));
                    if (!publishFile.equals((Object)tobePublishedFile)) break block7;
                    IResource[] ress = fromContainer.members();
                    int i = 0;
                    while (i < ress.length) {
                        IFile fromFile;
                        String relPath;
                        if (ress[i] instanceof IFile && PublishDescriptionFactory.isMatch(pattern, relPath = (fromFile = (IFile)ress[i]).getFullPath().removeFirstSegments(fromContainer.getFullPath().segmentCount()).toString())) {
                            return fromFile;
                        }
                        ++i;
                    }
                    break block8;
                }
                if (publishTo.charAt(publishTo.length() - 1) != '/') break block9;
                IResource[] ress = fromContainer.members();
                int i = 0;
                while (i < ress.length) {
                    IResource res = ress[i];
                    if (res instanceof IFile && ((IFile)res).getName().equals(publishFile.getName())) {
                        return (IFile)res;
                    }
                    ++i;
                }
                break block8;
            }
            if (publishTo.indexOf(42) == -1) break block8;
            IPath publishLocation = new Path(publishTo).removeLastSegments(1);
            IFolder parentFolder = this.webProject.getFolder("publish_folder").getFolder(publishLocation);
            if (publishFile.getParent().equals((Object)parentFolder)) {
                IFile[] fromFiles = SourceFileSeeker.findFiles(fromContainer);
                int i = 0;
                while (i < fromFiles.length) {
                    IFile fromFile = fromFiles[i];
                    String relPath = fromFile.getFullPath().removeFirstSegments(fromContainer.getFullPath().segmentCount()).toString();
                    if (PublishDescriptionFactory.isMatch(pattern, relPath) && SourceFileSeeker.getBaseName(fromFile.getName()).equals(SourceFileSeeker.getBaseName(publishFile.getName()))) {
                        return fromFile;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    static IFile[] findFiles(IContainer container) throws CoreException {
        ArrayList dist = new ArrayList();
        SourceFileSeeker.collectFiles(container, dist);
        return dist.toArray(new IFile[dist.size()]);
    }

    static void collectFiles(IContainer container, List dist) throws CoreException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource r = members[i];
            if (r instanceof IFile) {
                dist.add(r);
            } else if (r instanceof IContainer) {
                SourceFileSeeker.collectFiles((IContainer)r, dist);
            }
            ++i;
        }
    }

    static String getBaseName(String file) {
        int dotIndex;
        int separatorIndex = file.lastIndexOf(47);
        if (separatorIndex != -1) {
            file = file.substring(separatorIndex + 1);
        }
        if ((dotIndex = file.lastIndexOf(46)) != -1) {
            file = file.substring(0, dotIndex);
        }
        return file;
    }

    static Object[][] getPublishDescriptionEntries(IFile publishDescriptionFile) throws SAXException, IOException, ParserConfigurationException, CoreException {
        Document doc = docBuilderFactory.newDocumentBuilder().parse(publishDescriptionFile.getContents());
        Element rootElem = doc.getDocumentElement();
        NodeList mappings = rootElem.getElementsByTagName("mapping");
        int len = mappings.getLength();
        Object[][] entries = new Object[len][2];
        int i = 0;
        while (i < len) {
            Object[] entry = entries[i];
            Element mappingElem = (Element)mappings.item(i);
            entry[0] = mappingElem.getAttribute("pattern");
            Element pubElem = (Element)mappingElem.getElementsByTagName("publish").item(0);
            String pubTo = pubElem.getAttribute("publish_to");
            entry[1] = pubTo.length() > 0 ? pubTo : null;
            ++i;
        }
        return entries;
    }

    void sortPublishDescriptorFiles(IFile[] files) throws CoreException {
        final IContainer htFolder = this.webProject.getFolder("htsources_folder");
        Arrays.sort(files, new Comparator(){

            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object o1, Object o2) {
                int s2;
                boolean inHtSource2;
                IFile f1 = (IFile)o1;
                IFile f2 = (IFile)o2;
                boolean inHtSource1 = SourceFileSeeker.isParentFolder(f1, htFolder);
                if (inHtSource1 != (inHtSource2 = SourceFileSeeker.isParentFolder(f2, htFolder))) {
                    return inHtSource1 ? 1 : -1;
                }
                int s1 = f1.getFullPath().segmentCount();
                return s1 == (s2 = f2.getFullPath().segmentCount()) ? 0 : (s1 < s2 ? 1 : -1);
            }
        });
    }

    static boolean isParentFolder(IFile file, IContainer target) {
        IFile res = file;
        while (!((res = res.getParent()) instanceof IWorkspaceRoot)) {
            if (!target.equals((Object)res)) continue;
            return true;
        }
        return false;
    }

    IFile[] findPublishDescriptorFiles() throws CoreException {
        ArrayList dist = new ArrayList();
        IResource[] folders = this.webProject.getProject().members();
        int i = 0;
        while (i < folders.length) {
            if (folders[i] instanceof IFolder) {
                SourceFileSeeker.doFindPublishDescriptorFile((IFolder)folders[i], dist);
            }
            ++i;
        }
        return dist.toArray(new IFile[dist.size()]);
    }

    static void doFindPublishDescriptorFile(IFolder folder, List dist) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile && ((IFile)resource).getName().equals(".publish")) {
                dist.add(resource);
            } else if (resource instanceof IFolder) {
                SourceFileSeeker.doFindPublishDescriptorFile((IFolder)resource, dist);
            }
            ++i;
        }
    }
}

