/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.publish;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class PublisherRegistory {
    static PublisherRegistory instance = null;
    Map publishOrders = this.initPublisherExtensions();

    public static PublisherRegistory getInstance() {
        if (instance == null) {
            instance = new PublisherRegistory();
        }
        return instance;
    }

    private PublisherRegistory() {
    }

    Map initPublisherExtensions() {
        HashMap<String, String[]> orders = new HashMap<String, String[]>();
        IExtensionPoint extPoint = Platform.getPluginRegistry().getExtensionPoint("com.narucy.webpub.core.publishers");
        IExtension[] exts = extPoint.getExtensions();
        int i = 0;
        while (i < exts.length) {
            IExtension ext = exts[i];
            IConfigurationElement[] elems = ext.getConfigurationElements();
            int j = 0;
            while (j < elems.length) {
                IConfigurationElement elem = elems[j];
                if (elem.getName().equals("publisher")) {
                    String id = elem.getAttribute("id");
                    Path scriptFilePath = new Path(elem.getAttribute("script"));
                    URL url = ext.getDeclaringPluginDescriptor().find((IPath)scriptFilePath);
                    if (url == null) {
                        throw new RuntimeException("Invalid publisher extension entry: " + id + " (" + scriptFilePath + " is not found)");
                    }
                    String scriptFullPath = url.getFile();
                    String klass = elem.getAttribute("class");
                    String description = elem.getAttribute("description");
                    orders.put(id, new String[]{scriptFullPath, klass, description});
                }
                ++j;
            }
            ++i;
        }
        return orders;
    }

    public String[] getPublishByKeys() {
        return this.publishOrders.keySet().toArray(new String[this.publishOrders.size()]);
    }

    public String getPublishScriptFileLocation(String by) {
        Object publisher = this.publishOrders.get(by);
        return publisher != null ? ((String[])publisher)[0] : null;
    }

    public String getPublishClassName(String by) {
        Object publisher = this.publishOrders.get(by);
        return publisher != null ? ((String[])publisher)[1] : null;
    }

    public String getPublishDescription(String by) {
        Object publisher = this.publishOrders.get(by);
        return publisher != null ? ((String[])publisher)[2] : null;
    }
}

