/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.publish;

import com.narucy.webpub.core.RubyStacktrace;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.publish.BuildErrorReader;
import com.narucy.webpub.core.publish.BuildResultReader;
import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.core.publish.PublisherRegistory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class PublisherBuilder
extends IncrementalProjectBuilder {
    public static final String ID_BUILDER = "com.narucy.webpub.core.publisherBuilder";
    public static final String ID_MARKER_PUBLISHER_PROBLEM = "com.narucy.webpub.core.publisher.problem";
    public static final File UNPARSED_LINES_TEMPORARY_FILE = new File(System.getProperty("java.io.tmpdir"), "com.narucy.webpub.core.publish.unparsedlines");
    String baseScriptPath = WebpubPlugin.getDefault().getDescriptor().find((IPath)new Path("scripts/bin/pubtool.rb")).getFile();
    int readSleepMs = 10;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.buildPrepare();
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void buildPrepare() {
        UNPARSED_LINES_TEMPORARY_FILE.delete();
    }

    void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Publish all sources", 1024);
            IResource[] resources = this.findTargetResources();
            if (resources.length > 0) {
                this.doPublish(resources, (IProgressMonitor)new SubProgressMonitor(monitor, 1024 / resources.length));
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            monitor.done();
            throw throwable;
        }
        Object var3_5 = null;
        monitor.done();
    }

    IResource[] findTargetResources() throws CoreException {
        IProject project = this.getProject();
        WebProject webProject = (WebProject)project.getNature("com.narucy.webpub.core.publishNature");
        IContainer publishFolder = webProject.getFolder("publish_folder");
        IContainer scriptsFolder = webProject.getFolder("scripts_folder");
        ArrayList<IResource> dist = new ArrayList<IResource>();
        IResource[] resources = project.members();
        int i = 0;
        while (i < resources.length) {
            IResource res = resources[i];
            if (res instanceof IFile) {
                dist.add(res);
            } else if (res instanceof IFolder && !res.equals((Object)publishFolder) && !res.equals((Object)scriptsFolder)) {
                PublisherBuilder.findResources((IFolder)res, dist);
            }
            ++i;
        }
        return dist.toArray(new IResource[dist.size()]);
    }

    static void findResources(IFolder folder, ArrayList dist) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource res = resources[i];
            dist.add(res);
            if (res instanceof IFolder) {
                PublisherBuilder.findResources((IFolder)res, dist);
            }
            ++i;
        }
    }

    void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Incremental Publish", 1);
            final ArrayList publishTargets = new ArrayList();
            delta.accept(new IResourceDeltaVisitor(){
                PublishDescriptionFactory fac = PublishDescriptionFactory.getInstance();

                public boolean visit(IResourceDelta delta) throws CoreException {
                    int kind = delta.getKind();
                    if (kind == 1 || kind == 4) {
                        IResource res = delta.getResource();
                        try {
                            if (this.fac.create(res) != null) {
                                publishTargets.add(res);
                            }
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, "Error occastion in build process:" + res, (Throwable)e));
                        }
                        catch (IllegalConfigurationException e) {
                            throw new CoreException((IStatus)new Status(2, "com.narucy.webpub.core", 0, "Illegal publish configuration file:" + e.getIllegalFile(), (Throwable)e));
                        }
                    }
                    return true;
                }
            });
            if (publishTargets.size() > 0) {
                this.doPublish(publishTargets.toArray(new IResource[publishTargets.size()]), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    WebProject getWebProject() throws CoreException {
        return (WebProject)this.getProject().getNature("com.narucy.webpub.core.publishNature");
    }

    void deleteMarker(IResource res) throws CoreException {
        if (res.isAccessible()) {
            IMarker[] markers = res.findMarkers(null, false, 0);
            int i = 0;
            while (i < markers.length) {
                IMarker m = markers[i];
                if (m.getAttribute(ID_MARKER_PUBLISHER_PROBLEM) != null) {
                    m.delete();
                }
                ++i;
            }
        }
    }

    void doPublish(IResource[] resources, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                IMarker marker;
                monitor.beginTask("Publish process", -1);
                int i = 0;
                while (i < resources.length) {
                    this.deleteMarker(resources[i]);
                    ++i;
                }
                IProject project = this.getProject();
                String charset = ((WebProject)project.getNature("com.narucy.webpub.core.publishNature")).getString("ht_charset");
                IPath pubConfigFile = this.generatePublishConfig();
                String command = String.valueOf(this.baseScriptPath) + " --workspace " + project.getWorkspace().getRoot().getLocation() + " --plugin_properties " + pubConfigFile + " --files " + this.joinResourceArray(resources);
                Process process = WebpubPlugin.getDefault().rubyExec(command, project.getLocation());
                BuildResultReader resultReader = new BuildResultReader(process.getInputStream(), charset);
                BuildErrorReader errorReader = new BuildErrorReader(process.getErrorStream(), charset);
                resultReader.start();
                errorReader.start();
                while (!(resultReader.isDone() && errorReader.isDone() || monitor.isCanceled())) {
                    Thread.sleep(this.readSleepMs);
                    monitor.worked(1);
                }
                Object[] errorEntries = resultReader.errors.keySet().toArray();
                int i2 = 0;
                while (i2 < errorEntries.length) {
                    String[] entry = (String[])errorEntries[i2];
                    IResource res = this.findResourceFronPath(entry[0], resources);
                    if (res != null && res.exists()) {
                        marker = res.createMarker("org.eclipse.core.resources.problemmarker");
                        marker.setAttribute(ID_MARKER_PUBLISHER_PROBLEM, true);
                        marker.setAttribute("userEditable", true);
                        String[] errorLines = (String[])resultReader.errors.get(entry);
                        marker.setAttribute("message", (Object)errorLines[0]);
                        marker.setAttribute("severity", 2);
                    }
                    ++i2;
                }
                String[] lines = resultReader.getUnparsedLines();
                if (lines.length > 0) {
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(UNPARSED_LINES_TEMPORARY_FILE), charset));
                    try {
                        int i3 = 0;
                        while (i3 < lines.length) {
                            writer.println(lines[i3]);
                            ++i3;
                        }
                    }
                    catch (Throwable errorLines) {
                        marker = null;
                        if (writer != null) {
                            writer.close();
                        }
                        throw errorLines;
                    }
                    marker = null;
                    if (writer != null) {
                        writer.close();
                    }
                }
                ArrayList<WebProject> refreshed = new ArrayList<WebProject>();
                int i4 = 0;
                while (i4 < resources.length) {
                    IResource r = resources[i4];
                    WebProject wp = (WebProject)r.getProject().getNature("com.narucy.webpub.core.publishNature");
                    if (wp != null && !refreshed.contains((Object)wp)) {
                        refreshed.add(wp);
                        wp.getFolder("publish_folder").refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    ++i4;
                }
                String[] errorLog = errorReader.getErrorLog();
                RubyStacktrace[] traces = RubyStacktrace.createFromLines(errorLog);
                if (traces.length > 0) {
                    throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, traces[0].getMessage(), (Throwable)traces[0]));
                }
            }
            catch (InterruptedException e) {
                WebpubPlugin.handleException(e);
            }
            catch (IOException e) {
                IPath rubyInterpreter = WebpubPlugin.getDefault().getRubyCommandPath();
                String msg = !rubyInterpreter.toFile().exists() ? "Ruby interpreter is not exist: " + rubyInterpreter + " - Please settings in preference page \"Web Publisher > Ruby Interpreter\"." : e.getMessage();
                throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, msg, (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            Object var16_27 = null;
            monitor.done();
            throw throwable;
        }
        Object var16_28 = null;
        monitor.done();
    }

    String joinResourceArray(IResource[] resources) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < resources.length) {
            buff.append(resources[i].getLocation().toString());
            if (i != resources.length - 1) {
                buff.append(',');
            }
            ++i;
        }
        return buff.toString();
    }

    IResource findResourceFronPath(String resourcePath, IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            Path path;
            IFile f;
            IResource res = resources[i];
            if (res.getLocation().toString().equals(resourcePath)) {
                return res;
            }
            IWorkspaceRoot root = res.getWorkspace().getRoot();
            String workspaceDirName = root.getLocation().lastSegment();
            int index = resourcePath.indexOf(workspaceDirName);
            if (index != -1 && (f = root.getFile((IPath)(path = new Path(resourcePath.substring(index + workspaceDirName.length()))))).exists()) {
                return f;
            }
            ++i;
        }
        return null;
    }

    IPath generatePublishConfig() throws CoreException {
        PublisherRegistory registory = PublisherRegistory.getInstance();
        IOException error = null;
        File file = new File(System.getProperty("java.io.tmpdir"), "publish.properties");
        BufferedWriter writer = null;
        try {
            try {
                FileOutputStream out = new FileOutputStream(file);
                writer = new BufferedWriter(new OutputStreamWriter(out));
                String[] byKeys = registory.getPublishByKeys();
                int i = 0;
                while (i < byKeys.length) {
                    String k = byKeys[i];
                    writer.write(String.valueOf(k) + "," + registory.getPublishScriptFileLocation(k) + "," + registory.getPublishClassName(k) + "\n");
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                error = e;
            }
            catch (IOException e) {
                error = e;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                error = e;
            }
            if (error != null) {
                throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 4, "Error occasion in publish properties file generation", (Throwable)error));
            }
            throw throwable;
        }
        Object var9_13 = null;
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException e) {
            error = e;
        }
        if (error != null) {
            throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 4, "Error occasion in publish properties file generation", (Throwable)error));
        }
        return new Path(file.toString());
    }
}

