/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core.publish;

import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.Wildcard;
import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescription;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PublishDescriptionFactory {
    public static final String PUBLISH_DESCRIPTION_FILENAME = ".publish";
    static final String PUBLISHCODE_BEGIN = "<?publish ";
    static final String PUBLISHCODE_END = "?>";
    static PublishDescriptionFactory instance = new PublishDescriptionFactory();
    DocumentBuilderFactory docBuilderFac = DocumentBuilderFactory.newInstance();
    String[] ignorePatterns = new String[]{"CVS", ".publish"};

    public static PublishDescriptionFactory getInstance() {
        return instance;
    }

    private PublishDescriptionFactory() {
    }

    public PublishDescription create(Iterator ite) throws IllegalConfigurationException {
        while (ite.hasNext()) {
            String line = (String)ite.next();
            if (line == null) continue;
            int begin = line.indexOf(PUBLISHCODE_BEGIN);
            int end = line.indexOf(PUBLISHCODE_END);
            if (begin == -1 || end == -1) continue;
            PublishDescription desc = this.createFromMatcher(line.substring(begin + PUBLISHCODE_BEGIN.length(), end));
            return desc;
        }
        return null;
    }

    public PublishDescription create(IResource file) throws IllegalConfigurationException, CoreException, IOException {
        if (!this.checkPublishSource(file) || this.isPublishIgnore(file)) {
            return null;
        }
        PublishDescription desc = null;
        if (file instanceof IFile) {
            desc = this.createFromFile((IFile)file);
        }
        if (desc == null) {
            desc = this.createFromParent(file);
        }
        if (desc != null) {
            this.initPublishLocation(file, desc);
        }
        return desc;
    }

    public PublishDescription createFromFile(IFile file) throws IllegalConfigurationException, CoreException, IOException {
        WebProject wp = (WebProject)file.getProject().getNature("com.narucy.webpub.core.publishNature");
        if (!file.exists() || this.isPublishIgnore((IResource)file) || !file.isLocal(0) || wp == null || !wp.isHTExtension(file.getFileExtension())) {
            return null;
        }
        TextReader reader = null;
        try {
            try {
                reader = new TextReader(file.getContents());
                PublishDescription publishDescription = this.create(reader);
                Object var5_5 = null;
                if (reader != null) {
                    reader.close();
                }
                return publishDescription;
            }
            catch (IllegalConfigurationException e) {
                e.illegalFile = file;
                throw e;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var5_6 = null;
                if (reader == null) break block6;
                reader.close();
            }
            throw throwable;
        }
    }

    void initPublishLocation(IResource source, PublishDescription desc) throws CoreException, IllegalConfigurationException {
        if (desc.getPublishTo() != null) {
            return;
        }
        Pattern wildCard = Pattern.compile("(.+)/\\*\\.(.+?)$");
        IProject proj = source.getProject();
        WebProject webProj = (WebProject)proj.getNature("com.narucy.webpub.core.publishNature");
        if (webProj == null) {
            return;
        }
        IContainer publishFolder = webProj.getFolder("publish_folder");
        String publishPath = desc.getArgument("publish_to");
        if (publishPath != null) {
            IFolder res;
            if (publishPath.charAt(0) == '/') {
                publishPath = publishPath.substring(1);
            }
            if (publishPath.charAt(publishPath.length() - 1) == '/') {
                res = publishFolder.getFolder((IPath)new Path(publishPath));
            } else {
                Matcher m = wildCard.matcher(publishPath);
                if (m.matches()) {
                    IFolder folder = publishFolder.getFolder((IPath)new Path(m.group(1)));
                    String ext = source.getFileExtension();
                    String publishFileName = source.getName().replaceFirst(String.valueOf(ext) + "$", m.group(2));
                    res = folder.getFile(publishFileName);
                } else {
                    res = publishFolder.getFile((IPath)new Path(publishPath));
                }
            }
            desc.setPublishTo((IResource)res);
            desc.setArgument("publish_to", null);
        } else {
            IResource publishLocation = this.htSourceLocationToPublishLocation(source);
            if (publishLocation != null) {
                desc.setPublishTo(publishLocation);
            } else {
                throw new IllegalConfigurationException("can not define publish location:" + desc);
            }
        }
    }

    IResource htSourceLocationToPublishLocation(IResource res) throws CoreException {
        WebProject webProj = (WebProject)res.getProject().getNature("com.narucy.webpub.core.publishNature");
        String htSourceFolder = webProj.getFolder("htsources_folder").getFullPath().toString();
        String resPath = res.getFullPath().toString();
        if (resPath.indexOf(htSourceFolder) != -1) {
            String relativePath = resPath.substring(htSourceFolder.toString().length() + 1, resPath.length());
            return webProj.getFolder("publish_folder").getFile((IPath)new Path(relativePath));
        }
        return null;
    }

    PublishDescription createFromParent(IResource targetFile) throws IllegalConfigurationException, CoreException {
        PublishDescription desc = null;
        IFile publishDescriptionFile = this.findPublishDescriptionFile(targetFile);
        if (publishDescriptionFile != null) {
            desc = this.createFromPropertyFile(targetFile, publishDescriptionFile);
        }
        if (desc == null) {
            desc = this.createDefaultPublishDescription(targetFile);
        }
        return desc;
    }

    public IFile findPublishDescriptionFile(IResource target) throws CoreException {
        if (this.checkPublishSource(target)) {
            IResource res = target;
            while ((res = res.getParent()) instanceof IFolder) {
                IResource propFile = ((IFolder)res).findMember(PUBLISH_DESCRIPTION_FILENAME);
                if (!(propFile instanceof IFile) || !propFile.exists()) continue;
                return (IFile)propFile;
            }
        }
        return null;
    }

    PublishDescription createDefaultPublishDescription(IResource targetFile) throws CoreException {
        WebProject webProj;
        if (targetFile.exists() && (webProj = (WebProject)targetFile.getProject().getNature("com.narucy.webpub.core.publishNature")) != null) {
            IContainer htSourceFolder = webProj.getFolder("htsources_folder");
            IResource res = targetFile;
            while ((res = res.getParent()) instanceof IFolder) {
                IResource copyTarget;
                if (!res.equals((Object)htSourceFolder) || (copyTarget = this.htSourceLocationToPublishLocation(targetFile)) == null) continue;
                PublishDescription desc = new PublishDescription("copy");
                desc.setPublishTo(copyTarget);
                return desc;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PublishDescription createFromPropertyFile(IResource source, IFile propFile) throws IllegalConfigurationException {
        block23: {
            block21: {
                block19: {
                    block20: {
                        stream = null;
                        error = null;
                        try {
                            try {
                                stream = propFile.getContents();
                                doc = this.docBuilderFac.newDocumentBuilder().parse(stream);
                                rootElem = doc.getDocumentElement();
                                mappingNodes = rootElem.getElementsByTagName("mapping");
                                relativePath = source.getFullPath().removeFirstSegments(propFile.getParent().getFullPath().segmentCount()).toString();
                                i = 0;
                                while (i < mappingNodes.getLength()) {
                                    elem = (Element)mappingNodes.item(i);
                                    if (PublishDescriptionFactory.isMatch(elem.getAttribute("pattern"), relativePath) && (genElem = (Element)elem.getElementsByTagName("publish").item(0)).getAttribute("by") != null) {
                                        var14_17 = this.createAsElem(genElem);
                                        var12_18 = null;
                                        if (stream == null) break block19;
                                        break block20;
                                    }
                                    ++i;
                                }
                                break block21;
                            }
                            catch (SAXException e) {
                                error = e;
                                break block21;
                            }
                            catch (IOException e) {
                                error = e;
                                break block21;
                            }
                            catch (ParserConfigurationException e) {
                                error = e;
                                break block21;
                            }
                            catch (CoreException e) {
                                error = e;
                                break block21;
                            }
                            catch (IllegalConfigurationException e) {
                                e.illegalFile = propFile;
                                throw e;
                            }
                        }
                        catch (Throwable var13_24) {
                            var12_19 = null;
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (IOException e) {
                                    error = e;
                                }
                            }
                            if (error != null) {
                                throw new IllegalConfigurationException(error);
                            }
                            throw var13_24;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 251->258)] { 
lbl52:
                    // 1 sources

                    stream.close();
                    break block19;
lbl54:
                    // 1 sources

                    catch (IOException e) {
                        error = e;
                    }
                }
                if (error != null) {
                    throw new IllegalConfigurationException(error);
                }
                return var14_17;
            }
            var12_20 = null;
            if (stream != null) {
                ** try [egrp 2[TRYBLOCK] [6 : 251->258)] { 
lbl64:
                // 1 sources

                stream.close();
                break block23;
lbl66:
                // 1 sources

                catch (IOException e) {
                    error = e;
                }
            }
        }
        if (error != null) {
            throw new IllegalConfigurationException(error);
        }
        return null;
    }

    PublishDescription createAsElem(Element genElem) throws IllegalConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        NamedNodeMap atts = genElem.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node node = atts.item(i);
            map.put(node.getNodeName(), node.getNodeValue());
            ++i;
        }
        return this.createFromMap(map);
    }

    PublishDescription createFromMatcher(String code) throws IllegalConfigurationException {
        return this.createFromMap(this.createMapFromLine(code));
    }

    PublishDescription createFromMap(Map map) throws IllegalConfigurationException {
        String publishBy = (String)map.remove("by");
        PublishDescription desc = new PublishDescription(publishBy);
        Object[] keys = map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            String k = (String)keys[i];
            desc.setArgument(k, (String)map.get(k));
            ++i;
        }
        return desc;
    }

    Map createMapFromLine(String code) {
        StringTokenizer tokenizer = new StringTokenizer(code);
        HashMap<String, String> map = new HashMap<String, String>();
        while (tokenizer.hasMoreTokens()) {
            String keyValue = tokenizer.nextToken();
            int divideIndex = keyValue.indexOf(61);
            if (divideIndex == -1) {
                throw new RuntimeException("invalid token:" + keyValue);
            }
            String key = keyValue.substring(0, divideIndex).trim();
            String value = this.toAttributeValidate(keyValue.substring(divideIndex + 1));
            if (key == null || value == null) {
                throw new RuntimeException("invalid token:" + keyValue);
            }
            map.put(key, value);
        }
        return map;
    }

    String toAttributeValidate(String v) {
        if ((v = v.trim()).charAt(0) == '\"' && v.charAt(v.length() - 1) == '\"') {
            return v.substring(1, v.length() - 1);
        }
        return null;
    }

    public String[] getIgnorePatterns() {
        return (String[])this.ignorePatterns.clone();
    }

    public void setIgnorePatterns(String[] strings) {
        this.ignorePatterns = (String[])strings.clone();
    }

    boolean checkPublishSource(IResource res) throws CoreException {
        if (!res.exists()) {
            return false;
        }
        WebProject wp = (WebProject)res.getProject().getNature("com.narucy.webpub.core.publishNature");
        if (wp != null) {
            IContainer pubFolder = wp.getFolder("publish_folder");
            IResource r = res;
            while ((r = r.getParent()) instanceof IFolder) {
                if (!pubFolder.equals((Object)r)) continue;
                return false;
            }
        }
        return true;
    }

    boolean isPublishIgnore(IResource resource) throws CoreException {
        String name = resource.getName();
        int i = 0;
        while (i < this.ignorePatterns.length) {
            String pattern = this.ignorePatterns[i];
            if (PublishDescriptionFactory.isMatch(pattern, name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static boolean isMatch(String pattern, String relativePath) {
        if (pattern.equalsIgnoreCase(relativePath)) {
            return true;
        }
        if (PublishDescriptionFactory.isRegexpPattern(pattern)) {
            String regexp = pattern.substring(1, pattern.length() - 1);
            return Pattern.matches(regexp, relativePath);
        }
        Wildcard wildcard = new Wildcard(pattern);
        return wildcard.match(relativePath);
    }

    static void p(Object o) {
        System.out.println(":" + o);
    }

    static boolean isRegexpPattern(String pattern) {
        return pattern.charAt(0) == '/' && pattern.charAt(pattern.length() - 1) == '/';
    }
}

