/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.core;

import com.narucy.webpub.core.WebProjectConfigurationLoader052;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.TocFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class WebProject
extends Preferences
implements IProjectNature {
    public static final String DESCRIPTION_FILENAME = ".webproject";
    public static final String ID_NATURE = "com.narucy.webpub.core.publishNature";
    public static final String KEY_HTSOURCES_FOLDER = "htsources_folder";
    public static final String KEY_SCRIPTS_FOLDER = "scripts_folder";
    public static final String KEY_PUBLISH_FOLDER = "publish_folder";
    public static final String KEY_HT_EXTENSIONS = "ht_extensions";
    public static final String KEY_HT_CHARSET = "ht_charset";
    public static final String KEY_TOC_PATHES = "toc_pathes";
    public static final String KEY_MAPPED_URL = "mapped_url";
    IProject project = null;
    HashMap tocCache = new HashMap();
    IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                WebProject.this.handleResourceChange(event);
            }
            catch (CoreException e) {
                WebpubPlugin.handleException((Exception)((Object)e));
            }
        }
    };

    public WebProject() {
        this.setDefault(KEY_HTSOURCES_FOLDER, "");
        this.setDefault(KEY_SCRIPTS_FOLDER, "");
        this.setDefault(KEY_PUBLISH_FOLDER, "");
        this.setDefault(KEY_HT_EXTENSIONS, new String[]{"html", "htm", "erb"});
        this.setDefault(KEY_HT_CHARSET, "UTF-8");
        this.setDefault(KEY_TOC_PATHES, "");
        this.setDefault(KEY_MAPPED_URL, "");
    }

    void handleResourceChange(IResourceChangeEvent event) throws CoreException {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource res = delta.getResource();
                if (res instanceof IProject && delta.getKind() == 2 && res.equals((Object)WebProject.this.project)) {
                    res.getWorkspace().removeResourceChangeListener(WebProject.this.resourceChangeListener);
                }
                return true;
            }
        });
    }

    public IFile[] getTocFiles() {
        String[] pathes = this.getArray(KEY_TOC_PATHES);
        IFile[] files = new IFile[pathes.length];
        int i = 0;
        while (i < pathes.length) {
            files[i] = this.project.getFile(pathes[i]);
            ++i;
        }
        return files;
    }

    void removeTocCache(IFile f) throws CoreException {
        this.tocCache.remove(f);
    }

    public void setProject(IProject p) {
        if (this.project != p) {
            this.project = p;
            p.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
            try {
                this.load();
            }
            catch (CoreException e) {
                WebpubPlugin.handleException((Exception)((Object)e));
            }
        }
    }

    public void setDefault(String name, String[] vals) {
        this.setDefault(name, WebProject.toLine(vals));
    }

    public void setValue(String name, String[] vals) {
        this.setValue(name, WebProject.toLine(vals));
    }

    public String[] getArray(String name) {
        return WebProject.toArray(this.getString(name));
    }

    public String[] getDefaultArray(String name) {
        return WebProject.toArray(this.getDefaultString(name));
    }

    public static String[] toArray(String s) {
        return s.length() > 0 ? s.split("\\s+") : new String[]{};
    }

    public static String toLine(String[] val) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < val.length) {
            buff.append(val[i]);
            if (i != val.length - 1) {
                buff.append(' ');
            }
            ++i;
        }
        return buff.toString();
    }

    public boolean isHTExtension(String extension) {
        if (extension != null) {
            Object[] exts = this.getArray(KEY_HT_EXTENSIONS);
            Arrays.sort(exts);
            return Arrays.binarySearch(exts, extension) >= 0;
        }
        return false;
    }

    public void load() throws CoreException {
        IFile descFile = this.project.getFile(DESCRIPTION_FILENAME);
        if (descFile.isAccessible()) {
            try {
                this.load(descFile.getContents());
                if (this.getString(KEY_HTSOURCES_FOLDER).equals(this.getString(KEY_PUBLISH_FOLDER))) {
                    System.out.println("Convert web project nature configuration file:" + WebProjectConfigurationLoader052.reloadDescription(this));
                    this.storePreferences();
                }
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, "Can not read web project configuration file:" + descFile, (Throwable)e));
            }
        }
    }

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] cmds = desc.getBuildSpec();
        Object[] cmdIds = new String[cmds.length];
        ArrayList<ICommand> newCmds = new ArrayList<ICommand>();
        int i = 0;
        while (i < cmds.length) {
            ICommand cmd = cmds[i];
            cmdIds[i] = cmd.getBuilderName();
            newCmds.add(cmd);
            ++i;
        }
        Arrays.sort(cmdIds);
        if (Arrays.binarySearch(cmdIds, "com.narucy.webpub.core.templateSynchronizeBuilder") < 0) {
            ICommand tmplCmd = desc.newCommand();
            tmplCmd.setBuilderName("com.narucy.webpub.core.templateSynchronizeBuilder");
            newCmds.add(tmplCmd);
        }
        if (Arrays.binarySearch(cmdIds, "com.narucy.webpub.core.publisherBuilder") < 0) {
            ICommand publishCmd = desc.newCommand();
            publishCmd.setBuilderName("com.narucy.webpub.core.publisherBuilder");
            newCmds.add(publishCmd);
        }
        desc.setBuildSpec(newCmds.toArray(new ICommand[newCmds.size()]));
        this.project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
    }

    public void deconfigure() throws CoreException {
    }

    public IContainer getFolder(String key) {
        return this.pathToContainer(this.getString(key));
    }

    public IContainer pathToContainer(String folderPath) {
        if (folderPath.length() == 0) {
            return this.project;
        }
        if (folderPath.charAt(0) == '/') {
            Path path = new Path(folderPath);
            IWorkspaceRoot root = this.project.getWorkspace().getRoot();
            IProject proj = root.getProject(path.segment(0));
            if (path.segmentCount() <= 1) {
                return proj;
            }
            return proj.getFolder(path.removeFirstSegments(1));
        }
        return this.project.getFolder(folderPath);
    }

    public IProject getProject() {
        return this.project;
    }

    public Toc getToc(IFile f) {
        Toc toc = (Toc)((Object)this.tocCache.get(f));
        if (toc == null) {
            try {
                toc = TocFactory.createToc(f);
                this.tocCache.put(f, toc);
            }
            catch (CoreException e) {
                WebpubPlugin.handleException((Exception)((Object)e));
            }
        }
        return toc;
    }

    public void storePreferences() throws CoreException {
        try {
            IFile descFile = this.project.getFile(DESCRIPTION_FILENAME);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(descFile.getLocation().toFile());
                this.store(out, null);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            Object var3_6 = null;
            if (out != null) {
                out.close();
            }
            descFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException e) {
            WebpubPlugin.handleException(e);
        }
    }

    void distributeFolders(IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Create Web Project Folders", 3);
            String[] keys = new String[]{KEY_HTSOURCES_FOLDER, KEY_SCRIPTS_FOLDER, KEY_PUBLISH_FOLDER};
            int i = 0;
            while (i < keys.length) {
                IContainer folder = this.getFolder(keys[i]);
                if (!folder.exists()) {
                    if (folder instanceof IFolder) {
                        ((IFolder)folder).create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        throw new CoreException((IStatus)new Status(4, "com.narucy.webpub.core", 0, "Specify container is not exist:" + folder, null));
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        Object var5_7 = null;
        monitor.done();
    }

    public IFile[] findFileMembers(String key) throws CoreException {
        return WebProject.findFileMembers(this.getFolder(key));
    }

    static IFile[] findFileMembers(IContainer folder) throws CoreException {
        ArrayList dist = new ArrayList();
        WebProject.findFileMembers(folder, dist);
        return dist.toArray(new IFile[dist.size()]);
    }

    static void findFileMembers(IContainer folder, ArrayList distlist) throws CoreException {
        IResource[] files = folder.members();
        int i = 0;
        while (i < files.length) {
            IResource res = files[i];
            if (res instanceof IFolder) {
                WebProject.findFileMembers((IContainer)((IFolder)res), distlist);
            } else if (res instanceof IFile) {
                distlist.add(res);
            }
            ++i;
        }
    }

    public static void storeNewProject(IProject project, String htSourceFolder, String scriptsFolder, String publicFolder, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Store new web project", 4);
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setNatureIds(new String[]{ID_NATURE});
            boolean created = project.exists();
            if (!created) {
                project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (!project.isOpen()) {
                project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            if (created) {
                project.setDescription(desc, 1, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            WebProject wp = (WebProject)project.getNature(ID_NATURE);
            wp.setProject(project);
            wp.setValue(KEY_HTSOURCES_FOLDER, htSourceFolder);
            wp.setValue(KEY_SCRIPTS_FOLDER, scriptsFolder);
            wp.setValue(KEY_PUBLISH_FOLDER, publicFolder);
            wp.storePreferences();
            wp.distributeFolders((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            wp.configure();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        Object var8_10 = null;
        monitor.done();
    }
}

