/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import java.util.Arrays;
import java.util.regex.Pattern;

class StringDivider {
    static Pattern tagNameChoosePattern = Pattern.compile("<[\\s/]*(\\w+)\\s*.*>");
    static String[] splitRegexpCandidates = new String[]{"\\t", ",", " ", "\\s+"};

    private StringDivider() {
    }

    public static String[][] divide(String content) {
        return StringDivider.divide(content, StringDivider.getDivideSuitedRegexp(content));
    }

    public static String[][] divide(String content, String regexp) {
        String[] lines = content.split("\n");
        int len = lines.length;
        String[][] dist = new String[len][];
        int max = Integer.MIN_VALUE;
        int i = 0;
        while (i < len) {
            String line = lines[i];
            String[] cells = line.split(regexp);
            dist[i] = cells;
            if (max < cells.length) {
                max = cells.length;
            }
            ++i;
        }
        i = 0;
        while (i < len) {
            Object[] newArray = new String[max];
            Arrays.fill(newArray, "");
            System.arraycopy(dist[i], 0, newArray, 0, dist[i].length);
            dist[i] = newArray;
            ++i;
        }
        return dist;
    }

    static String getDivideSuitedRegexp(String content) {
        String[] lines = content.split("\n");
        String resultRegexp = null;
        int score = Integer.MAX_VALUE;
        int cellCount = Integer.MIN_VALUE;
        int i = 0;
        while (i < splitRegexpCandidates.length) {
            String regexp = splitRegexpCandidates[i];
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            int j = 0;
            while (j < lines.length) {
                String[] vals = lines[j].split(regexp);
                if (max < vals.length) {
                    max = vals.length;
                }
                if (min > vals.length) {
                    min = vals.length;
                }
                ++j;
            }
            int s = max - min;
            if (score > s || score == s && max > cellCount) {
                cellCount = max;
                score = s;
                resultRegexp = regexp;
            }
            ++i;
        }
        return resultRegexp;
    }
}

