/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;
import com.narucy.webpub.ui.wizards.PresetSelectionWizardPage;
import com.narucy.webpub.ui.wizards.WebProjectStructureWizardPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewWebProjectWizard
extends BasicNewResourceWizard {
    IWorkbench workbench;
    WizardNewProjectCreationPage newProjectPage;
    WebProjectStructureWizardPage structurePage;
    PresetSelectionWizardPage presetPage;
    IRunnableWithProgress distProcess = new IRunnableWithProgress(){

        IPerspectiveDescriptor findWebDevPerspective() {
            return WebpubUIPlugin.getDefault().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.narucy.webpub.WebDevPerspective");
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Create project resources", 7);
            IProject project = NewWebProjectWizard.this.newProjectPage.getProjectHandle();
            try {
                try {
                    this.createProject(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    WebProject webProj = (WebProject)project.getNature("com.narucy.webpub.core.publishNature");
                    NewWebProjectWizard.this.presetPage.storePresets(webProj, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    IWorkbenchPage workbenchPage = WebpubUIPlugin.getActivePage();
                    workbenchPage.setPerspective(this.findWebDevPerspective());
                    IResourceNavigator navigatorView = (IResourceNavigator)workbenchPage.findView("org.eclipse.ui.views.ResourceNavigator");
                    if (navigatorView != null) {
                        TreeViewer tree = navigatorView.getViewer();
                        tree.expandToLevel((Object)project, 2);
                        tree.setSelection((ISelection)new StructuredSelection((Object)project));
                    }
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                monitor.done();
                throw throwable;
            }
            Object var7_10 = null;
            monitor.done();
        }

        void createProject(IProject project, IProgressMonitor monitor) throws CoreException {
            try {
                monitor.beginTask("Distribute Web Project Folder", -1);
                WebProjectStructureBlock block = NewWebProjectWizard.this.structurePage.getBlock();
                WebProject.storeNewProject((IProject)project, (String)block.getText("htsources_folder"), (String)block.getText("scripts_folder"), (String)block.getText("publish_folder"), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                IResourceNavigator navigatorView = (IResourceNavigator)WebpubUIPlugin.getActivePage().findView("org.eclipse.ui.views.ResourceNavigator");
                if (navigatorView != null) {
                    TreeViewer tree = navigatorView.getViewer();
                    tree.expandToLevel((Object)project, -1);
                    tree.setSelection((ISelection)new StructuredSelection((Object)project));
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                monitor.done();
                throw throwable;
            }
            Object var6_8 = null;
            monitor.done();
        }
    };

    public NewWebProjectWizard() {
        this.setWindowTitle("New Web Project");
        this.setNeedsProgressMonitor(true);
    }

    static WizardNewProjectCreationPage createNewProjectCreationPage() {
        WizardNewProjectCreationPage page = new WizardNewProjectCreationPage("WizardNewProjectCreationPage");
        page.setDescription("Enter the required data to generate website source files");
        page.setTitle("Web Project");
        page.setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("wizban/newwebproj_wiz.gif"));
        return page;
    }

    public void addPages() {
        this.newProjectPage = NewWebProjectWizard.createNewProjectCreationPage();
        this.addPage((IWizardPage)this.newProjectPage);
        this.structurePage = new WebProjectStructureWizardPage();
        this.addPage((IWizardPage)this.structurePage);
        this.presetPage = new PresetSelectionWizardPage();
        this.addPage((IWizardPage)this.presetPage);
    }

    public boolean canFinish() {
        if (super.canFinish()) {
            return this.getContainer().getCurrentPage() == this.getPages()[this.getPageCount() - 1];
        }
        return false;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, true, this.distProcess);
        }
        catch (InvocationTargetException e) {
            WebpubUIPlugin.handleException(e);
            return false;
        }
        catch (InterruptedException e) {
            WebpubUIPlugin.handleException(e);
            return false;
        }
        return true;
    }
}

