/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.ui.wizards.EditElementWizard;
import com.narucy.webpub.ui.wizards.EditElementWizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ListElementWizardPage
extends EditElementWizardPage {
    static final String[] LIST_TYPES = new String[]{"ul", "ol", "dl"};
    Combo types;

    public ListElementWizardPage() {
        super("ListElementWizardPage");
        this.setTitle("List");
        this.setDescription("Editing list element.");
    }

    protected void createChildControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label labe = new Label(parent, 0);
        labe.setText("List &Type:");
        this.types = new Combo(parent, 12);
        int i = 0;
        while (i < LIST_TYPES.length) {
            String type = LIST_TYPES[i];
            this.types.add(type);
            if (this.getElementName().equals(type)) {
                this.types.select(i);
            }
            ++i;
        }
        this.types.setLayoutData((Object)new GridData(768));
        this.types.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListElementWizardPage.this.setElementName(ListElementWizardPage.this.types.getText());
                ListElementWizardPage.this.refreshPreview();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getPreviewText() {
        String content = ((EditElementWizard)this.getWizard()).getSelection().getText().trim();
        String elemName = this.getElementName();
        switch (this.getEditType()) {
            case 1: {
                content = EditElementWizardPage.chooseContent(content).trim();
                break;
            }
            case 0: {
                String[] lines = content.split("\n+");
                StringBuffer result = new StringBuffer();
                int i = 0;
                while (i < lines.length) {
                    String itemElemName = elemName.equals("dl") ? (i % 2 == 0 ? "dt" : "dd") : "li";
                    result.append("<" + itemElemName + ">" + lines[i].trim() + "</" + itemElemName + ">\n");
                    ++i;
                }
                content = result.toString();
            }
        }
        return "<" + elemName + ">\n" + content + "</" + elemName + ">\n";
    }
}

