/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import com.narucy.webpub.ui.WebpubUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

class InitialWebPageWizardPage
extends WizardPage {
    static final String SETTING_KEY_INITIAL_FILE_HISTORY = "InitialWebPageHistory";
    static final int MAX_HISTORY_COUNT = 10;
    IContainer htSourceFolder;
    Combo historyCombo;
    IFile result = null;
    IInputValidator validator;
    IDialogSettings settings;

    static IDialogSettings getDialogSetting() {
        IDialogSettings rootSettings = WebpubUIPlugin.getDefault().getDialogSettings();
        IDialogSettings wizpageSettings = rootSettings.getSection(SETTING_KEY_INITIAL_FILE_HISTORY);
        if (wizpageSettings == null) {
            wizpageSettings = rootSettings.addNewSection(SETTING_KEY_INITIAL_FILE_HISTORY);
        }
        return wizpageSettings;
    }

    protected InitialWebPageWizardPage(IContainer htSourceFolder, IInputValidator validator) {
        super("NewWebPageWizardPage");
        this.htSourceFolder = htSourceFolder;
        this.validator = validator;
        this.setTitle("Web Page");
        this.setDescription("Select initial HTML document for new web page.");
        this.settings = InitialWebPageWizardPage.getDialogSetting();
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        this.setControl((Control)base);
        base.setLayout((Layout)new GridLayout(2, false));
        new Label(base, 0).setText("Initial HTML:");
        new Label(base, 0);
        this.historyCombo = new Combo(base, 2060);
        this.historyCombo.setLayoutData((Object)new GridData(768));
        Button button = new Button(base, 8);
        button.setText("B&rowse...");
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InitialWebPageWizardPage.this.handleBrowseButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.historyCombo.add("");
        String[] history = this.settings.getArray(this.htSourceFolder.getProject().getName());
        if (history != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < history.length && i < 10) {
                IResource file = root.findMember(history[i]);
                if (file instanceof IFile && this.validator.isValid(file.getName()) == null) {
                    String path = file.getFullPath().toString();
                    int index = this.historyCombo.indexOf(path);
                    if (index == -1) {
                        this.historyCombo.add(path);
                    } else {
                        this.historyCombo.select(index);
                    }
                }
                ++i;
            }
        }
        this.historyCombo.select(0);
    }

    void handleBrowseButtonPressed() {
        Object res;
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)this.htSourceFolder, "Selection initial html file for new web page");
        if (dialog.open() == 0 && (res = dialog.getResult()[0]) instanceof IFile) {
            IFile result = (IFile)res;
            String filePath = result.getFullPath().toString();
            String errMsg = this.validator.isValid(filePath);
            if (errMsg != null) {
                this.setErrorMessage(errMsg);
            } else {
                this.historyCombo.remove(0);
                this.historyCombo.add(filePath, 0);
                this.historyCombo.select(0);
            }
        }
    }

    public IFile getResult() {
        String result = this.historyCombo.getText();
        return result.length() > 0 ? (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(result) : null;
    }

    public void distributeSettings() {
        String[] history = this.historyCombo.getItems();
        if (history[0].length() > 0) {
            this.settings.put(this.htSourceFolder.getProject().getName(), history);
        }
    }
}

