/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.wizards;

import java.io.InputStream;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class ImageBrowser
extends Canvas {
    Image image = null;

    public ImageBrowser(Composite parent) {
        super(parent, 262144);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageBrowser.this.dispose(e);
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ImageBrowser.this.paint(e);
            }
        });
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageBrowser.this.disposeImage();
            }
        });
    }

    void dispose(DisposeEvent e) {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint) {
        if (this.image == null) {
            return new Point(0, 0);
        }
        ImageData data = this.image.getImageData();
        return new Point(data.width, data.height);
    }

    public synchronized Image browseImage(InputStream stream) {
        Display display = this.getDisplay();
        this.disposeImage();
        if (stream != null) {
            this.image = new Image((Device)display, stream);
        }
        return this.image;
    }

    void paint(PaintEvent e) {
        boolean overHeight;
        boolean overWidth;
        if (this.image == null) {
            return;
        }
        ImageData data = this.image.getImageData();
        int w = data.width;
        int h = data.height;
        boolean bl = overWidth = e.width > w;
        if (overWidth) {
            e.gc.fillRectangle(w, 0, e.width - w, h);
        }
        boolean bl2 = overHeight = e.height > h;
        if (overHeight) {
            e.gc.fillRectangle(0, h, w, e.height - h);
            if (overWidth) {
                e.gc.fillRectangle(w, h, e.width - w, e.height - h);
            }
        }
        e.gc.fillRectangle(0, 0, w, h);
        e.gc.drawImage(this.image, 0, 0, data.width, data.height, 0, 0, w, h);
    }

    void disposeImage() {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
    }
}

