/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.ui.views.AbstractWebBrowser;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class IEWebBrowser
extends AbstractWebBrowser {
    URL lastBrowseUrl = null;
    OleFrame webFrame;
    OleControlSite controlSite;
    OleAutomation oleAutomation;

    public Control createControl(Composite composite) {
        this.webFrame = new OleFrame(composite, 0);
        this.controlSite = new OleControlSite((Composite)this.webFrame, 0, "Shell.Explorer");
        this.oleAutomation = new OleAutomation((OleClientSite)this.controlSite);
        if (this.controlSite.doVerb(-5) != 0) {
            throw new RuntimeException("can not create web browser control");
        }
        this.browsePage(null);
        this.controlSite.addEventListener(252, new OleListener(){

            public void handleEvent(OleEvent event) {
                String urlStr = event.arguments[1].getString();
                URL before = IEWebBrowser.this.lastBrowseUrl;
                IEWebBrowser.this.lastBrowseUrl = IEWebBrowser.toURL(urlStr);
                IEWebBrowser.this.firePropertyChanged(new PropertyChangeEvent((Object)IEWebBrowser.this, "url_change_started", (Object)before, (Object)IEWebBrowser.this.lastBrowseUrl));
            }
        });
        this.controlSite.addEventListener(259, new OleListener(){

            public void handleEvent(OleEvent event) {
                String urlStr = event.arguments[1].getString();
                IEWebBrowser.this.firePropertyChanged(new PropertyChangeEvent((Object)IEWebBrowser.this, "url_change_complted", null, (Object)IEWebBrowser.toURL(urlStr)));
            }
        });
        return this.webFrame;
    }

    static URL toURL(String anyUrl) {
        if (anyUrl.substring(0, 5).equals("about")) {
            return null;
        }
        URL url = null;
        try {
            url = new URL(anyUrl);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                url = new File(anyUrl).toURL();
            }
            catch (MalformedURLException malformedURLException2) {}
        }
        return url;
    }

    public URL getCurrentURL() {
        return this.lastBrowseUrl;
    }

    public synchronized void browsePage(URL url) {
        String[] setUrlIds = new String[]{"Navigate", "URL"};
        int[] rgdispid = this.oleAutomation.getIDsOfNames(setUrlIds);
        int dispIdMember = rgdispid[0];
        String arg = url != null ? url.toString() : "about:blank";
        Variant[] rgvarg = new Variant[]{new Variant(arg)};
        int[] rgdispidNamedArgs = new int[]{rgdispid[1]};
        this.oleAutomation.invoke(dispIdMember, rgvarg, rgdispidNamedArgs);
        this.webFrame.redraw();
    }

    public String getTitle() {
        OleAutomation automation = new OleAutomation((OleClientSite)this.controlSite);
        int[] docDispId = automation.getIDsOfNames(new String[]{"Document"});
        Variant document = automation.getProperty(docDispId[0]);
        OleAutomation docAutomation = document.getAutomation();
        int[] titleDispId = docAutomation.getIDsOfNames(new String[]{"title"});
        Variant title = docAutomation.getProperty(titleDispId[0]);
        return title.getString();
    }
}

