/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.views;

import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescription;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.core.publish.SourceFileSeeker;
import com.narucy.webpub.ui.MnemonicNamer;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.views.HTPreView;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;

class HTPreviewLinkWithEditorManager {
    public static final String M_PREVIEW_TARGETS = "previewTargets";
    public static final String M_PREVIEW_BEHAVIOR = "previewBehavior";
    IPreferenceStore preferenceStore = WebpubUIPlugin.getDefault().getPreferenceStore();
    HTPreView htPreview;
    MnemonicNamer mnemonicNamer = new MnemonicNamer(){

        public String toLabel(Object obj) {
            int fullLen;
            IFile file = (IFile)obj;
            String name = file.getName();
            String fullPath = file.getFullPath().toString().substring(1);
            int nameLen = name.length();
            if (nameLen + (fullLen = fullPath.length()) > 32) {
                fullPath = String.valueOf(fullPath.substring(0, fullLen - nameLen)) + "...";
            }
            return String.valueOf(name) + "  [" + fullPath + "]";
        }
    };
    HashMap fileActions = new HashMap();
    Action linkWithEditorAction;
    IResourceChangeListener resourceListener = new IResourceChangeListener(){
        final ArrayList removeTargets = new ArrayList();
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(this){
            final /* synthetic */ 2 this$1;
            {
                this.this$1 = var1_1;
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource r = delta.getResource();
                if (r instanceof IFile && delta.getKind() == 2) {
                    this.this$1.removeTargets.add(r);
                }
                return true;
            }
        };

        public void resourceChanged(IResourceChangeEvent event) {
            this.removeTargets.clear();
            try {
                IFile[] removes;
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    delta.accept(this.visitor);
                }
                if ((removes = this.removeTargets.toArray(new IFile[this.removeTargets.size()])).length > 0) {
                    this.removeTargets.clear();
                    HTPreviewLinkWithEditorManager.this.asyncExec(new Runnable(this, removes){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IFile[] val$removes;
                        {
                            this.this$1 = var1_1;
                            this.val$removes = iFileArray;
                        }

                        public void run() {
                            2.access$0(this.this$1).undefinePreviewAction(this.val$removes);
                        }
                    });
                }
            }
            catch (CoreException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }

        static /* synthetic */ HTPreviewLinkWithEditorManager access$0(2 var0) {
            return var0.HTPreviewLinkWithEditorManager.this;
        }
    };
    IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("ht_preview_link_with_editor")) {
                HTPreviewLinkWithEditorManager.this.linkWithEditorAction.setChecked(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    };
    IPartListener partListener = new IPartListener(){

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                HTPreviewLinkWithEditorManager.this.unregistObserveEditor((IEditorPart)part);
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                HTPreviewLinkWithEditorManager.this.registObserveEditor((IEditorPart)part);
            }
        }

        public void partActivated(IWorkbenchPart part) {
            if (HTPreviewLinkWithEditorManager.this.isLinkWithEditor() && part instanceof IEditorPart) {
                IFile editFile = HTPreviewLinkWithEditorManager.this.getFile((IEditorPart)part);
                HTPreviewLinkWithEditorManager.this.changeBrowseFile(editFile);
            }
        }
    };

    public HTPreviewLinkWithEditorManager(HTPreView view) {
        this.htPreview = view;
        IMenuManager mgr = this.htPreview.getMenuManager();
        mgr.add((IContributionItem)new Separator(M_PREVIEW_TARGETS));
        mgr.add((IContributionItem)new Separator(M_PREVIEW_BEHAVIOR));
        this.linkWithEditorAction = new Action("&Link with Editor", 2){

            public void run() {
                HTPreviewLinkWithEditorManager.this.handleLinkWithEditorCheck();
            }
        };
        this.linkWithEditorAction.setToolTipText("Link with Editor");
        this.linkWithEditorAction.setImageDescriptor(WebpubUIPlugin.getDefault().getImageDescriptor("ctool16/synced.gif"));
        mgr.add((IAction)this.linkWithEditorAction);
        IEditorReference[] refs = this.htPreview.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < refs.length) {
            this.registObserveEditor(refs[i].getEditor(true));
            ++i;
        }
        this.linkWithEditorAction.setChecked(this.preferenceStore.getBoolean("ht_preview_link_with_editor"));
        view.getWebBrowser().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("url_change_started")) {
                    try {
                        HTPreviewLinkWithEditorManager.this.handleWebBorwserUrlChanged(event);
                    }
                    catch (Exception e) {
                        WebpubUIPlugin.handleException(e);
                    }
                }
            }
        });
        view.getSite().getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    void handleLinkWithEditorCheck() {
        boolean checked = this.linkWithEditorAction.isChecked();
        this.preferenceStore.setValue("ht_preview_link_with_editor", checked);
        if (!checked) {
            return;
        }
        IFile[] registedFiles = this.getRegistedFiles();
        if (registedFiles.length > 0) {
            IFile currentBrowseFile = this.htPreview.getCurrentPublishFrom();
            if (currentBrowseFile != null) {
                IFile editFile = this.getFile(this.htPreview.getSite().getPage().getActiveEditor());
                int i = 0;
                while (i < registedFiles.length) {
                    IFile r = registedFiles[i];
                    if (currentBrowseFile.equals((Object)r)) {
                        return;
                    }
                    if (editFile.equals((Object)r)) {
                        this.changeBrowseFile(r);
                    }
                    ++i;
                }
            }
        } else {
            this.htPreview.browsePage(null);
        }
    }

    void handleWebBorwserUrlChanged(PropertyChangeEvent event) throws CoreException {
        URL after = (URL)event.getNewValue();
        IFile from = new SourceFileSeeker(after).getPublishFrom();
        URL before = (URL)event.getOldValue();
        IFile[] files = this.getRegistedFiles();
        int i = 0;
        while (i < files.length) {
            IFile f = files[i];
            this.getOpenAction(f).setChecked(f.equals((Object)from));
            ++i;
        }
        if (before != after && (before != null ? !before.equals(after) : !after.equals(before)) && this.isLinkWithEditor() && this.fileActions.containsKey(from)) {
            this.htPreview.getSite().getPage().openEditor(from);
        }
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }

    public IFile[] getRegistedFiles() {
        return this.fileActions.keySet().toArray(new IFile[this.fileActions.size()]);
    }

    void changeBrowseFile(IFile editFile) {
        if (editFile != null && this.htPreview.isPreviewble(editFile) && this.fileActions.containsKey(editFile) && !this.getOpenAction(editFile).isChecked()) {
            this.browseFileAsHTSource(editFile);
        }
    }

    public void definePreviewAction(final IFile file) {
        if (!this.fileActions.containsKey(file)) {
            Action action = new Action(this.mnemonicNamer.getLabel(file), 8){

                public void run() {
                    HTPreviewLinkWithEditorManager.this.browseFileAsHTSource(file);
                }
            };
            ActionContributionItem actionItem = new ActionContributionItem((IAction)action);
            this.fileActions.put(file, actionItem);
            this.htPreview.getMenuManager().appendToGroup(M_PREVIEW_TARGETS, (IContributionItem)actionItem);
        }
    }

    IAction getOpenAction(IFile file) {
        return this.fileActions.containsKey(file) ? ((ActionContributionItem)this.fileActions.get(file)).getAction() : null;
    }

    IFile getFile(IEditorPart editor) {
        IEditorInput input = editor.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    void registObserveEditor(IEditorPart editor) {
        IFile file = this.getFile(editor);
        if (file != null && this.htPreview.isPreviewble(file)) {
            this.definePreviewAction(file);
        }
    }

    void unregistObserveEditor(IEditorPart editor) {
        IFile file = this.getFile(editor);
        if (file != null) {
            this.undefinePreviewAction(file);
        }
        if (this.isLinkWithEditor() && this.fileActions.isEmpty()) {
            this.htPreview.browsePage(null);
        }
    }

    void undefinePreviewAction(IFile file) {
        this.undefinePreviewAction(new IFile[]{file});
    }

    void undefinePreviewAction(IFile[] files) {
        IMenuManager mgr = this.htPreview.getMenuManager();
        int i = 0;
        while (i < files.length) {
            ActionContributionItem actionItem = (ActionContributionItem)this.fileActions.remove(files[i]);
            if (actionItem != null) {
                mgr.remove((IContributionItem)actionItem);
            }
            this.mnemonicNamer.release(files[i]);
            ++i;
        }
    }

    static URL getPublishUrl(IFile file) {
        PublishDescription desc;
        if (file != null && (desc = HTPreviewLinkWithEditorManager.getPublishDescription(file)) != null) {
            try {
                return desc.getPublishTo().getLocation().toFile().toURL();
            }
            catch (MalformedURLException e) {
                WebpubUIPlugin.handleException(e);
            }
        }
        return null;
    }

    public static PublishDescription getPublishDescription(IFile file) {
        try {
            return PublishDescriptionFactory.getInstance().create((IResource)file);
        }
        catch (IllegalConfigurationException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        catch (IOException e) {
            WebpubUIPlugin.handleException(e);
        }
        return null;
    }

    boolean isLinkWithEditor() {
        return this.linkWithEditorAction != null && this.linkWithEditorAction.isChecked();
    }

    void asyncExec(Runnable proc) {
        Display disp;
        Shell sh;
        IWorkbenchPartSite site = this.htPreview.getSite();
        if (site != null && (sh = site.getShell()) != null && !sh.isDisposed() && (disp = sh.getDisplay()) != null && !disp.isDisposed()) {
            disp.asyncExec(proc);
        }
    }

    void browseFileAsHTSource(IFile file) {
        PublishDescription desc = HTPreviewLinkWithEditorManager.getPublishDescription(file);
        try {
            IResource res;
            IFile f = file;
            if (desc != null && (res = desc.getPublishTo()) instanceof IFile) {
                f = (IFile)res;
            }
            this.htPreview.browsePage(f.getLocation().toFile().toURL());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void dispose() {
        this.htPreview.getSite().getPage().removePartListener(this.partListener);
        this.preferenceStore.removePropertyChangeListener(this.preferenceChangeListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
    }

    public Action getLinkWithEditorAction() {
        return this.linkWithEditorAction;
    }
}

