/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.properties;

import com.narucy.webpub.core.StatusChangeListener;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.ui.JFaceUtilities;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.properties.WebProjectStructureBlock;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class WebProjectPage
extends PropertyPage {
    WebProject webProject;
    WebProjectStructureBlock block;
    Combo charsetsCombo;
    ListViewer extsListViewer;
    ListViewer mappedUrlViewer;
    Button addExtButton;
    Button removeExtButton;
    Button editExtButton;
    Button addUrlButton;
    Button removeUrlButton;
    Button editUrlButton;
    SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == WebProjectPage.this.addExtButton) {
                WebProjectPage.this.handleAddExtension();
            }
            if (e.widget == WebProjectPage.this.removeExtButton) {
                WebProjectPage.this.handleRemoveExtension();
            }
            if (e.widget == WebProjectPage.this.editExtButton) {
                WebProjectPage.this.handleRemoveExtension();
            }
            if (e.widget == WebProjectPage.this.addUrlButton) {
                WebProjectPage.this.handleAddUrl();
            }
            if (e.widget == WebProjectPage.this.removeUrlButton) {
                WebProjectPage.this.handleRemoveUrl();
            }
            if (e.widget == WebProjectPage.this.editUrlButton) {
                WebProjectPage.this.handleEditUrl();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Control createContents(Composite parent) {
        this.setDescription("Web Project directory structure setting");
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProject proj = (IProject)iAdaptable.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.narucy.webpub.core.WebProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.webProject = (WebProject)proj.getAdapter((Class)clazz2);
        this.block = new WebProjectStructureBlock(new StatusChangeListener(){

            public void statusChanged(IStatus status) {
                int serverity = status.getSeverity();
                switch (serverity) {
                    case 4: {
                        WebProjectPage.this.setErrorMessage(status.getMessage());
                        break;
                    }
                    case 1: 
                    case 2: {
                        WebProjectPage.this.setMessage(status.getMessage(), serverity);
                        break;
                    }
                    case 0: {
                        WebProjectPage.this.setErrorMessage(null);
                        WebProjectPage.this.setMessage(null, serverity);
                    }
                }
                WebProjectPage.this.updateApplyButton();
            }
        });
        Composite base = null;
        try {
            base = this.block.createControl(parent, proj);
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
            return new Label(parent, 0);
        }
        new Label(base, 0).setText("HTML char code:");
        this.charsetsCombo = new Combo(base, 2052);
        GridData gd = new GridData(768);
        gd.horizontalIndent = 5;
        this.charsetsCombo.setLayoutData((Object)gd);
        String[] supportsCharCodes = WebpubPlugin.getSupportCharsets();
        int i = 0;
        while (i < supportsCharCodes.length) {
            this.charsetsCombo.add(supportsCharCodes[i]);
            ++i;
        }
        Label labe = new Label(base, 0);
        labe.setLayoutData((Object)new GridData(2));
        labe.setText("HTML file &type extension:");
        this.createExtensionViewer(base).setLayoutData((Object)new GridData(1808));
        labe = new Label(base, 0);
        labe.setLayoutData((Object)new GridData(2));
        labe.setText("&Mapped URL:");
        this.createMappedUrlViewer(base).setLayoutData((Object)new GridData(1808));
        this.reload();
        return base;
    }

    Control createExtensionViewer(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.extsListViewer = new ListViewer(base);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.extsListViewer.getControl().setLayoutData((Object)gd);
        this.extsListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extsListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean selectedItem = !event.getSelection().isEmpty();
                WebProjectPage.this.editExtButton.setEnabled(selectedItem);
                WebProjectPage.this.removeExtButton.setEnabled(selectedItem);
            }
        });
        this.addExtButton = this.createButton(base, "&Add");
        this.editExtButton = this.createButton(base, "&Edit");
        this.removeExtButton = this.createButton(base, "&Remove");
        return base;
    }

    Control createMappedUrlViewer(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.mappedUrlViewer = new ListViewer(base);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        this.mappedUrlViewer.getControl().setLayoutData((Object)gd);
        this.mappedUrlViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mappedUrlViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean selectedItem = !event.getSelection().isEmpty();
                WebProjectPage.this.editUrlButton.setEnabled(selectedItem);
                WebProjectPage.this.removeUrlButton.setEnabled(selectedItem);
            }
        });
        this.addUrlButton = this.createButton(base, "A&dd");
        this.editUrlButton = this.createButton(base, "Ed&it");
        this.removeUrlButton = this.createButton(base, "Re&move");
        return base;
    }

    Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(258));
        button.setText(text);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    String inputExtension(String initialExt) {
        InputDialog dialog = new InputDialog(this.getShell(), "File Extension", "Input HTML file type extension", initialExt, JFaceUtilities.FILE_EXTENSION_VALIDATOR);
        return dialog.open() == 0 ? dialog.getValue() : null;
    }

    URL inputUrl(String initialUrl) {
        InputDialog dialog = new InputDialog(this.getShell(), "URL", "Input project public document mapped url", initialUrl, null);
        return dialog.open() == 0 ? WebProjectPage.toURL(dialog.getValue()) : null;
    }

    static URL toURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(urlStr).toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    void reload() {
        String charset = this.webProject.getString("ht_charset");
        this.setCharset(charset);
        this.extsListViewer.setInput(new ArrayList<String>(Arrays.asList(this.webProject.getArray("ht_extensions"))));
        this.extsListViewer.refresh();
        this.mappedUrlViewer.setInput(new ArrayList<String>(Arrays.asList(this.webProject.getArray("mapped_url"))));
        this.mappedUrlViewer.refresh();
    }

    void setCharset(String charset) {
        int index = this.charsetsCombo.indexOf(charset);
        if (index != -1) {
            this.charsetsCombo.select(index);
        } else {
            this.charsetsCombo.add(charset, 0);
            this.charsetsCombo.select(0);
        }
    }

    void handleAddExtension() {
        ArrayList list = (ArrayList)this.extsListViewer.getInput();
        String obj = this.inputExtension(null);
        if (obj != null) {
            Object sel = ((IStructuredSelection)this.extsListViewer.getInput()).getFirstElement();
            if (sel == null) {
                list.add(obj);
            } else {
                list.add(list.indexOf(sel), obj);
            }
        }
        this.extsListViewer.refresh();
    }

    void handleRemoveExtension() {
        ArrayList list = (ArrayList)this.extsListViewer.getInput();
        list.removeAll(((IStructuredSelection)this.extsListViewer.getSelection()).toList());
        this.extsListViewer.refresh();
    }

    void handleEditExtension() {
        ArrayList list = (ArrayList)this.extsListViewer.getInput();
        String sel = (String)((IStructuredSelection)this.extsListViewer.getSelection()).getFirstElement();
        String newExt = this.inputExtension(sel);
        if (newExt != null) {
            int index = list.indexOf(sel);
            list.remove(index);
            list.add(index, newExt);
            this.extsListViewer.refresh();
        }
    }

    void handleAddUrl() {
        ArrayList list = (ArrayList)this.mappedUrlViewer.getInput();
        URL url = this.inputUrl(null);
        if (url != null) {
            Object sel = ((IStructuredSelection)this.mappedUrlViewer.getSelection()).getFirstElement();
            if (sel == null) {
                list.add(url.toString());
            } else {
                list.add(list.indexOf(sel), url.toString());
            }
            this.mappedUrlViewer.refresh();
        }
    }

    void handleRemoveUrl() {
        ArrayList list = (ArrayList)this.mappedUrlViewer.getInput();
        list.removeAll(((IStructuredSelection)this.mappedUrlViewer.getSelection()).toList());
        this.mappedUrlViewer.refresh();
    }

    void handleEditUrl() {
        ArrayList list = (ArrayList)this.mappedUrlViewer.getInput();
        String sel = (String)((IStructuredSelection)this.mappedUrlViewer.getSelection()).getFirstElement();
        URL newUrl = this.inputUrl(sel);
        if (newUrl != null) {
            int index = list.indexOf(sel);
            list.remove(index);
            list.add(index, newUrl.toString());
            this.mappedUrlViewer.refresh();
        }
    }

    protected void performDefaults() {
        this.setCharset(this.webProject.getString("ht_charset"));
        this.extsListViewer.setInput(new ArrayList<String>(Arrays.asList(this.webProject.getDefaultArray("ht_extensions"))));
        this.extsListViewer.refresh();
        this.mappedUrlViewer.setInput(new ArrayList<String>(Arrays.asList(this.webProject.getDefaultArray("mapped_url"))));
        this.mappedUrlViewer.refresh();
    }

    public boolean performOk() {
        this.webProject.setValue("htsources_folder", this.block.getText("htsources_folder"));
        this.webProject.setValue("scripts_folder", this.block.getText("scripts_folder"));
        this.webProject.setValue("publish_folder", this.block.getText("publish_folder"));
        this.webProject.setValue("ht_charset", this.charsetsCombo.getText());
        ArrayList exts = (ArrayList)this.extsListViewer.getInput();
        this.webProject.setValue("ht_extensions", exts.toArray(new String[exts.size()]));
        ArrayList urls = (ArrayList)this.mappedUrlViewer.getInput();
        this.webProject.setValue("mapped_url", urls.toArray(new String[urls.size()]));
        try {
            this.webProject.storePreferences();
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return true;
    }
}

