/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.toc;

import com.narucy.webpub.core.TextReader;
import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.SourceFileSeeker;
import com.narucy.webpub.core.toc.Toc;
import com.narucy.webpub.core.toc.Topic;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

class TocController {
    static final String FULL_PATH = "FULL_PATH";
    static final String[] DIRECTORY_INDEX_PAGE_NAMES = new String[]{"index", "default"};
    Toc toc;
    IContainer publishFolder;

    static {
        Arrays.sort(DIRECTORY_INDEX_PAGE_NAMES);
    }

    public TocController(IContainer pubFolder, Toc toc) {
        this.publishFolder = pubFolder;
        this.toc = toc;
    }

    public Topic[] insertResourceToToc(IResource res, Topic parentTopic) throws CoreException {
        if (res instanceof IContainer) {
            return this.insertContainerToToc((IContainer)res, parentTopic);
        }
        return new Topic[]{this.insertFileToToc((IFile)res, parentTopic)};
    }

    public Topic[] insertContainerToToc(IContainer res, Topic parentTopic) throws CoreException {
        ArrayList<Topic> dist = new ArrayList<Topic>();
        IContainer c = res;
        Topic newParentTopic = null;
        IFile parentFile = TocController.findDirectoryIndex(c);
        if (parentFile != null) {
            newParentTopic = this.insertFileToToc(parentFile, parentTopic);
            dist.add(newParentTopic);
        } else {
            String fullPath = c.getFullPath().toString();
            Topic[] topics = this.toc.getAllTopics();
            int i = 0;
            while (i < topics.length) {
                Topic t = topics[i];
                if (fullPath.equals(t.getAttribute(FULL_PATH))) {
                    newParentTopic = t;
                    break;
                }
                ++i;
            }
            if (newParentTopic == null) {
                newParentTopic = parentTopic.createTopic(null, "Group of " + TocController.toBaseName((IResource)c));
                newParentTopic.setAttribute(FULL_PATH, fullPath);
                dist.add(newParentTopic);
            }
        }
        IResource[] rs = c.members();
        int i = 0;
        while (i < rs.length) {
            Topic[] added = this.insertResourceToToc(rs[i], newParentTopic);
            dist.addAll(Arrays.asList(added));
            ++i;
        }
        return dist.toArray(new Topic[dist.size()]);
    }

    public static IFile findDirectoryIndex(IContainer container) throws CoreException {
        IResource[] rs = container.members();
        String dirBaseName = TocController.toBaseName((IResource)container);
        int i = 0;
        while (i < rs.length) {
            String baseName;
            IResource r = rs[i];
            if (r instanceof IFile && (Arrays.binarySearch(DIRECTORY_INDEX_PAGE_NAMES, baseName = TocController.toBaseName(r)) > 0 || dirBaseName.equals(baseName))) {
                return (IFile)r;
            }
            ++i;
        }
        return null;
    }

    public boolean isAlreadyAdded(IResource[] rs) {
        return this.getAlreadyAdded(rs).length == rs.length;
    }

    public IResource[] getAlreadyAdded(IResource[] rs) {
        ArrayList<IResource> dist = new ArrayList<IResource>();
        Topic[] topics = this.toc.getAllTopics();
        int i = 0;
        while (i < rs.length) {
            IResource r = rs[i];
            boolean file = r instanceof IFile;
            String p = file ? this.toHref((IFile)r) : r.getFullPath().toString();
            int j = 0;
            while (j < topics.length) {
                Topic t = topics[j];
                if (file ? p.equals(t.getHref()) : p.equals(t.getAttribute(FULL_PATH))) {
                    dist.add(r);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return dist.toArray(new IResource[dist.size()]);
    }

    static String toBaseName(IResource res) {
        String name = res.getName();
        int i = name.lastIndexOf(46);
        if (i != -1) {
            return name.substring(0, i - 1);
        }
        return name;
    }

    String toHref(IFile f) {
        return f.getFullPath().removeFirstSegments(this.publishFolder.getFullPath().segmentCount()).toString();
    }

    public Topic insertFileToToc(IFile f, Topic parentTopic) throws CoreException {
        String p = this.toHref(f);
        if (this.toc.findTopic(p) == null) {
            return parentTopic.createTopic(p, TocController.chooseTitle(f));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String chooseTitle(IFile f) throws CoreException {
        TextReader reader;
        block4: {
            String string;
            block3: {
                Pattern pattern = Pattern.compile(".*<title.*>(.+)</title>.*");
                IFile from = new SourceFileSeeker(f).getPublishFrom();
                WebProject wp = (WebProject)from.getProject().getNature("com.narucy.webpub.core.publishNature");
                String charset = wp.getString("ht_charset");
                reader = new TextReader(f.getContents(), charset);
                try {
                    while (reader.hasNext()) {
                        Matcher m = pattern.matcher(reader.nextLine());
                        if (!m.matches()) continue;
                        string = m.group(1);
                        Object var7_8 = null;
                        if (reader == null) return string;
                        break block3;
                    }
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
            }
            reader.close();
            return string;
        }
        Object var7_10 = null;
        if (reader == null) return null;
        reader.close();
        return null;
    }

    public Topic findNextSelectionTopic(Topic[] removeTopics) {
        this.toc.getAllTopics();
        Topic topic = removeTopics[0];
        while ((topic = topic.getPrevTopic(true)) != null) {
            if (TocController.isContain(removeTopics, topic)) continue;
            return topic;
        }
        topic = removeTopics[0];
        while ((topic = topic.getNextTopic(true)) != null) {
            if (TocController.isContain(removeTopics, topic)) continue;
            return topic;
        }
        return null;
    }

    public boolean isAllResourcesAdded() {
        IResource[] rs = this.getAllPublishResources();
        return this.getAlreadyAdded(rs).length == rs.length;
    }

    IResource[] getAllPublishResources() {
        ArrayList dist = new ArrayList();
        try {
            TocController.doFindResource(this.publishFolder, dist);
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
        return dist.toArray(new IResource[dist.size()]);
    }

    static void doFindResource(IContainer container, List dist) throws CoreException {
        IResource[] ress = container.members();
        int i = 0;
        while (i < ress.length) {
            IResource r = ress[i];
            dist.add(r);
            if (r instanceof IContainer) {
                TocController.doFindResource((IContainer)r, dist);
            }
            ++i;
        }
    }

    static boolean isContain(Topic[] removeTopic, Topic t) {
        int i = 0;
        while (i < removeTopic.length) {
            if (removeTopic[i].equals((Object)t)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

