/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescription;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.html.IRelativeResourceLinkChooser;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

class RubyScriptLink
implements IRelativeResourceLinkChooser {
    RubyScriptLink() {
    }

    public IFile chooseLink(ITextEditor editor) throws CoreException {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            String scriptPath;
            IFile htFile = ((IFileEditorInput)input).getFile();
            PublishDescription publishDesc = null;
            try {
                publishDesc = PublishDescriptionFactory.getInstance().create((IResource)htFile);
            }
            catch (IllegalConfigurationException ex) {
                new CoreException((IStatus)new Status(4, "com.narucy.webpub", 0, ex.getLocalizedMessage(), (Throwable)ex));
            }
            catch (IOException ex) {
                WebpubUIPlugin.handleException(ex);
            }
            if (publishDesc != null && (scriptPath = publishDesc.getArgument("script")) != null) {
                try {
                    WebProject webProject = (WebProject)htFile.getProject().getNature("com.narucy.webpub.core.publishNature");
                    return webProject.getFolder("scripts_folder").getFile((IPath)new Path(scriptPath));
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
            }
        }
        return null;
    }
}

