/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.html.CSSLink;
import com.narucy.webpub.ui.editors.html.IRelativeResourceLinkChooser;
import com.narucy.webpub.ui.editors.html.RubyScriptLink;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class HTEditorActionContributor
extends TextEditorActionContributor {
    static final String M_ID_RELLINK = "com.narucy.webpub.ui.hteditor.rellink";
    static final String M_PREFERENCE = "com.narucy.webpub.ui.hteditor.preference";
    IPreferenceStore pref = WebpubUIPlugin.getDefault().getPreferenceStore();
    IPropertyChangeListener prefListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            HTEditorActionContributor.this.refreshActionStatus();
        }
    };
    ArrayList linkFactories = new ArrayList();
    ITextEditor activeEditor = null;
    IMenuManager linkMenu = null;
    IAction wordWrapAction = null;

    public HTEditorActionContributor() {
        this.addResourceLinkerItem("rubyscript", "&Ruby Script", new RubyScriptLink());
        this.addResourceLinkerItem("css", "&Style Sheet", new CSSLink());
        this.pref.addPropertyChangeListener(this.prefListener);
    }

    void addResourceLinkerItem(String id, String name, IRelativeResourceLinkChooser chooser) {
        Object[] objectArray = new Object[4];
        objectArray[0] = id;
        objectArray[1] = name;
        objectArray[2] = chooser;
        this.linkFactories.add(objectArray);
    }

    String[] getIdList() {
        Object[] items = this.linkFactories.toArray();
        String[] ids = new String[items.length];
        int i = 0;
        while (i < items.length) {
            ids[i] = (String)((Object[])items[i])[0];
            ++i;
        }
        return ids;
    }

    Object[] findItem(String id) {
        Object[] items = this.linkFactories.toArray();
        int i = 0;
        while (i < items.length) {
            Object[] item = (Object[])items[i];
            if (item[0].equals(id)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    String getItemName(String id) {
        return (String)this.findItem(id)[1];
    }

    IAction getOpenLinkAction(String id) {
        Object[] item = this.findItem(id);
        Object act = (IAction)item[3];
        if (act == null) {
            String name = (String)this.findItem(id)[1];
            final IRelativeResourceLinkChooser chooser = (IRelativeResourceLinkChooser)item[2];
            act = new Action(name){

                public void run() {
                    if (HTEditorActionContributor.this.activeEditor != null) {
                        try {
                            IFile f = chooser.chooseLink(HTEditorActionContributor.this.activeEditor);
                            HTEditorActionContributor.this.getPage().openEditor(f);
                        }
                        catch (CoreException e) {
                            WebpubUIPlugin.handleException((Exception)((Object)e));
                        }
                    }
                }
            };
            item[3] = act;
        }
        return act;
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager editMenuMgr;
        super.contributeToMenu(menu);
        IMenuManager naviMenuMgr = menu.findMenuUsingPath("navigate");
        if (naviMenuMgr != null) {
            this.linkMenu = new MenuManager("&Relational File", M_ID_RELLINK);
            naviMenuMgr.appendToGroup("open.ext", (IContributionItem)this.linkMenu);
            String[] ids = this.getIdList();
            int i = 0;
            while (i < ids.length) {
                String id = ids[i];
                this.linkMenu.add(this.getOpenLinkAction(id));
                ++i;
            }
        }
        if ((editMenuMgr = menu.findMenuUsingPath("edit")) != null) {
            editMenuMgr.appendToGroup("editEnd", (IContributionItem)new Separator(M_PREFERENCE));
            editMenuMgr.appendToGroup(M_PREFERENCE, this.getWordWrapCheckAction());
        }
        this.refreshActionStatus();
    }

    void refreshActionStatus() {
        if (this.wordWrapAction != null) {
            this.wordWrapAction.setChecked(this.pref.getBoolean("ht_editor_wordwrap"));
        }
    }

    IAction getWordWrapCheckAction() {
        if (this.wordWrapAction == null) {
            this.wordWrapAction = new Action("&Word Wrap", 2){

                public void run() {
                    boolean wordWraped = HTEditorActionContributor.this.pref.getBoolean("ht_editor_wordwrap");
                    HTEditorActionContributor.this.pref.setValue("ht_editor_wordwrap", !wordWraped);
                }
            };
        }
        return this.wordWrapAction;
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        if (part == this.activeEditor) {
            return;
        }
        if (part instanceof ITextEditor) {
            this.activeEditor = (ITextEditor)part;
            Object[] items = this.linkFactories.toArray();
            int i = 0;
            while (i < items.length) {
                Object[] item = (Object[])items[i];
                String id = (String)item[0];
                IAction act = this.getOpenLinkAction(id);
                String name = (String)item[1];
                IRelativeResourceLinkChooser chooser = (IRelativeResourceLinkChooser)item[2];
                try {
                    boolean openTargetExist;
                    IFile f = chooser.chooseLink(this.activeEditor);
                    boolean bl = openTargetExist = f != null;
                    if (openTargetExist) {
                        act.setText(String.valueOf(name) + " (" + f.getName() + ")");
                    } else {
                        act.setText(name);
                    }
                    act.setEnabled(openTargetExist);
                }
                catch (CoreException e) {
                    WebpubUIPlugin.handleException((Exception)((Object)e));
                }
                ++i;
            }
        } else {
            this.activeEditor = null;
            this.linkMenu.setVisible(false);
        }
        this.linkMenu.updateAll(true);
    }

    public void dispose() {
        this.pref.removePropertyChangeListener(this.prefListener);
        super.dispose();
    }
}

