/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.template.Template;
import com.narucy.webpub.ui.WebpubUIPlugin;
import com.narucy.webpub.ui.editors.ColorManager;
import com.narucy.webpub.ui.editors.html.HTDocumentProvider;
import com.narucy.webpub.ui.editors.html.HTOutlinePage;
import com.narucy.webpub.ui.editors.html.HTViewerConfiguration;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.WorkbenchChainedTextFontFieldEditor;

public class HTEditor
extends TextEditor
implements IPropertyChangeListener {
    public static final String ID_KEYBIND_SCOPE = "com.narucy.webpub.ui.editors.html.HTEditorScope";
    static final String[] relationalPreferenceKeys = new String[]{"ht_editor_color_default", "ht_editor_color_tag", "ht_editor_color_comment", "ht_editor_color_erb", "ht_editor_color_attr", "ht_editor_color_processor"};
    ColorManager colorManager;
    HTDocumentProvider docProvider;
    HTOutlinePage outlinePage = null;
    static /* synthetic */ Class class$0;

    static {
        Arrays.sort(relationalPreferenceKeys);
    }

    public HTEditor() {
        this.setKeyBindingScopes(new String[]{ID_KEYBIND_SCOPE});
        this.colorManager = new ColorManager();
        IPreferenceStore prefStore = WebpubUIPlugin.getDefault().getPreferenceStore();
        prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setPreferenceStore(prefStore);
        WorkbenchChainedTextFontFieldEditor.startPropagate((IPreferenceStore)prefStore, (String)"org.eclipse.jface.textfont");
        HTViewerConfiguration conf = new HTViewerConfiguration(this.colorManager);
        this.setSourceViewerConfiguration(conf);
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.docProvider = new HTDocumentProvider();
        this.setDocumentProvider((IDocumentProvider)this.docProvider);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    HTOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new HTOutlinePage(this.getSourceViewer().getDocument());
            this.outlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    HTEditor.this.outlineSelectionChanged(event);
                }
            });
        }
        return this.outlinePage;
    }

    public void propertyChange(PropertyChangeEvent event) {
        HTViewerConfiguration conf = (HTViewerConfiguration)this.getSourceViewerConfiguration();
        if (conf != null) {
            String prop = event.getProperty();
            IPreferenceStore store = this.getPreferenceStore();
            StyledText styledText = this.getSourceViewer().getTextWidget();
            if (prop.equals("ht_editor_displayed_tab_editor")) {
                styledText.setTabs(store.getInt(prop));
            } else if (prop.equals("ht_editor_wordwrap")) {
                styledText.setWordWrap(store.getBoolean(prop));
            } else if (prop.equals("ht_editor_color_background")) {
                styledText.setBackground(this.colorManager.getColor(prop));
            } else {
                conf.propertyChange(event);
            }
        }
    }

    void outlineSelectionChanged(SelectionChangedEvent event) {
        Template tmpl;
        Integer lineNumber;
        IStructuredSelection sel;
        Object obj;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof Template && (lineNumber = (Integer)(tmpl = (Template)obj).getProperty((Object)"find_line_number")) != null) {
            int lineNum = lineNumber;
            this.jumpLine(lineNum);
        }
    }

    void jumpLine(int lineNum) {
        IDocument doc = this.getSourceViewer().getDocument();
        if (doc != null) {
            try {
                int offset = doc.getLineOffset(lineNum);
                TextSelection textSelection = new TextSelection(offset, 0);
                this.getSelectionProvider().setSelection((ISelection)textSelection);
            }
            catch (BadLocationException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return Arrays.binarySearch(relationalPreferenceKeys, event.getProperty()) >= 0;
    }

    protected void createActions() {
        super.createActions();
        this.installEncodingSupport();
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            try {
                WebProject wp = (WebProject)((IFileEditorInput)input).getFile().getProject().getNature("com.narucy.webpub.core.publishNature");
                if (wp != null) {
                    String charset = wp.getString("ht_charset");
                    this.fEncodingSupport.setEncoding(charset);
                }
            }
            catch (CoreException e) {
                WebpubUIPlugin.handleException((Exception)((Object)e));
            }
        }
        ContentAssistAction action = new ContentAssistAction(WebpubUIPlugin.getDefault().getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
    }

    public void dispose() {
        IPreferenceStore prefStore = this.getPreferenceStore();
        prefStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.colorManager.dispose();
        super.dispose();
    }
}

