/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors.html;

import com.narucy.webpub.ui.WebpubUIPlugin;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class HTContentAssistEngine {
    static final String RNG_BASE_DIR = "resources/xhtml_rng/";
    public static final String XHTML_BASIC = "xhtml-basic.rng";
    public static final String XHTML_STRICT = "xhtml-strict.rng";
    public static final String XHTML_TRANSITIONAL = "xhtml.rng";
    static HTContentAssistEngine instance = new HTContentAssistEngine();
    String currentType = null;
    URL xhtmlRelaxNGBaseUrl;
    HashMap rngReadCache = new HashMap();
    HashMap definedCache = new HashMap();
    HashMap bindedDefineCache = new HashMap();
    HashMap childElementsCache = new HashMap();
    HashMap attributesCache = new HashMap();
    DocumentBuilder builder;

    public static HTContentAssistEngine getInstance() {
        return instance;
    }

    public HTContentAssistEngine() {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        if (WebpubUIPlugin.getDefault() != null) {
            this.xhtmlRelaxNGBaseUrl = WebpubUIPlugin.getResource(RNG_BASE_DIR);
        } else {
            try {
                this.xhtmlRelaxNGBaseUrl = new File(RNG_BASE_DIR).toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
    }

    public String getCurrentType() {
        return this.currentType;
    }

    public void initTypes(String type) throws ParserConfigurationException, SAXException, IOException {
        this.currentType = type;
        this.definedCache.clear();
        this.bindedDefineCache.clear();
        this.childElementsCache.clear();
        this.attributesCache.clear();
        URL url = new URL(this.xhtmlRelaxNGBaseUrl, type);
        this.doInitGrammar(this.getDocumentElement(url), url);
    }

    public Element getDocumentElement(URL url) throws SAXException, IOException {
        Element e = (Element)this.rngReadCache.get(url);
        if (e == null) {
            Document doc = this.builder.parse(url.openStream());
            e = doc.getDocumentElement();
            this.rngReadCache.put(url, e);
        }
        return e;
    }

    void doInitGrammar(Element elem, URL loadedUrl) throws MalformedURLException, DOMException, SAXException, IOException {
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element e = (Element)nl.item(i);
                String elemName = e.getTagName();
                if (elemName.equals("include")) {
                    URL url = new URL(loadedUrl, e.getAttribute("href"));
                    this.doInitGrammar(this.getDocumentElement(url), url);
                } else if (elemName.equals("define")) {
                    String name = e.getAttribute("name");
                    if (this.definedCache.containsKey(name) && e.getAttribute("combine") != null) {
                        this.addBindedElem(e);
                    } else {
                        this.definedCache.put(name, e);
                    }
                }
            }
            ++i;
        }
    }

    void addBindedElem(Element e) {
        String name = e.getAttribute("name");
        ArrayList<Element> list = (ArrayList<Element>)this.bindedDefineCache.get(name);
        if (list == null) {
            list = new ArrayList<Element>();
            this.bindedDefineCache.put(name, list);
        }
        list.add(e);
    }

    public String[] getCandidateElements(String elemName) {
        if (!this.childElementsCache.containsKey(elemName)) {
            Object[] elems = this.findChildElements(elemName);
            if (elems != null) {
                Arrays.sort(elems);
            }
            this.childElementsCache.put(elemName, elems);
        }
        return (String[])this.childElementsCache.get(elemName);
    }

    Element findHTElement(String elemName) {
        Object[] defs = this.definedCache.values().toArray();
        int i = 0;
        while (i < defs.length) {
            NodeList ls = ((Element)defs[i]).getElementsByTagName("element");
            int j = 0;
            while (j < ls.getLength()) {
                Element e = (Element)ls.item(j);
                if (e.getAttribute("name").equals(elemName)) {
                    return e;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    String[] findChildElements(String elemName) {
        Element elem = this.findHTElement(elemName);
        if (elem == null) {
            return null;
        }
        Element[] childs = this.toFlatChildren(elem);
        ArrayList<String> dist = new ArrayList<String>();
        int i = 0;
        while (i < childs.length) {
            Element e = childs[i];
            if (e.getTagName().equals("element")) {
                dist.add(e.getAttribute("name"));
            }
            ++i;
        }
        return dist.size() > 0 ? dist.toArray(new String[dist.size()]) : null;
    }

    public String[] getCandidateAttribute(String elementName) {
        if (!this.attributesCache.containsKey(elementName)) {
            Object[] attrs = this.findAttributes(elementName);
            if (attrs != null) {
                Arrays.sort(attrs);
            }
            this.attributesCache.put(elementName, attrs);
        }
        return (String[])this.attributesCache.get(elementName);
    }

    String[] findAttributes(String name) {
        Element elem = this.findHTElement(name);
        if (elem == null) {
            return null;
        }
        Element[] childs = this.toFlatChildren(elem);
        ArrayList<String> dist = new ArrayList<String>();
        int i = 0;
        while (i < childs.length) {
            Element e = childs[i];
            if (e.getTagName().equals("attribute")) {
                dist.add(e.getAttribute("name"));
            }
            ++i;
        }
        return dist.size() > 0 ? dist.toArray(new String[dist.size()]) : null;
    }

    public boolean isEmptyElement(String elemName) {
        return this.findHTElement(elemName).getElementsByTagName("empty").getLength() > 0;
    }

    Element[] toFlatChildren(Element elem) {
        ArrayList dist = new ArrayList();
        this.toFlat(elem, dist);
        return dist.toArray(new Element[dist.size()]);
    }

    void toFlat(Element elem, List dist) {
        NodeList nl = elem.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof Element) {
                Element e = (Element)nl.item(i);
                dist.add(e);
                String tn = e.getTagName();
                if (tn.equals("zeroOrMore") || tn.equals("oneOrMore") || tn.equals("choice") || tn.equals("optional")) {
                    this.toFlat(e, dist);
                } else if (tn.equals("ref")) {
                    String name = e.getAttribute("name");
                    this.toFlat((Element)this.definedCache.get(name), dist);
                    List elems = (List)this.bindedDefineCache.get(name);
                    int j = 0;
                    while (elems != null && j < elems.size()) {
                        this.toFlat((Element)elems.get(j), dist);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }
}

