/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.editors;

import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements ISharedTextColors {
    HashMap colorTable = new HashMap();
    HashMap sharedImage = new HashMap();

    public Color getColor(String key) {
        IPreferenceStore store = WebpubUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = StringConverter.asRGB((String)(store.contains(key) ? store.getString(key) : key));
        return this.getColor(rgb);
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.colorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.colorTable.put(rgb, color);
        }
        return color;
    }

    public Image getImage(String path) {
        Image img = (Image)this.sharedImage.get(path);
        if (img == null) {
            ImageDescriptor desc = WebpubUIPlugin.getDefault().getImageDescriptor(path);
            if (desc != null) {
                img = desc.createImage();
            }
            this.sharedImage.put(path, img);
        }
        return img;
    }

    public void dispose() {
        Object[] colors = this.colorTable.values().toArray();
        int i = 0;
        while (i < colors.length) {
            ((Color)colors[i]).dispose();
            ++i;
        }
        Object[] imgs = this.sharedImage.values().toArray();
        int i2 = 0;
        while (i2 < imgs.length) {
            ((Image)imgs[i2]).dispose();
            ++i2;
        }
    }
}

