/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui.actions;

import com.narucy.webpub.ui.HTParser;
import com.narucy.webpub.ui.wizards.EditElementWizard;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ModifyElementAction
implements IEditorActionDelegate {
    ITextEditor editor = null;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor instanceof ITextEditor) {
            this.editor = (ITextEditor)targetEditor;
        }
    }

    public void run(IAction action) {
        try {
            IDocument doc = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput());
            ITextSelection sel = HTParser.getElementRange(doc, ((ITextSelection)this.editor.getSelectionProvider().getSelection()).getOffset());
            this.editor.getSelectionProvider().setSelection((ISelection)sel);
            String text = sel.getText();
            if (text == null) {
                throw new BadLocationException("Invalid text selection, can't choose element.");
            }
            String elemName = HTParser.chooseElementName(text);
            WizardDialog wizDialog = new WizardDialog(this.editor.getSite().getShell(), (IWizard)new EditElementWizard(this.editor, elemName)){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10;
                }
            };
            wizDialog.open();
        }
        catch (BadLocationException e) {
            ErrorDialog dialog = new ErrorDialog(this.editor.getSite().getShell(), "Text Selection Error", "Invalid element hierarchy?", (IStatus)new Status(2, "com.narucy.webpub", 0, e.getLocalizedMessage(), (Throwable)e), 2);
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

