/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.ui.WebpubUIPlugin;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class WebResourcesDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID_DECORATOR = "com.narucy.webpub.webResourceDecorator";
    static String[] folderKeys = new String[]{"htsources_folder", "scripts_folder", "publish_folder"};
    HashMap listenersCache = new HashMap();
    static /* synthetic */ Class class$0;

    static int getKeyIndex(String k) {
        int i = 0;
        while (i < folderKeys.length) {
            if (folderKeys[i].equals(k)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void decorate(Object element, IDecoration decoration) {
        try {
            Object[] entry;
            WebProject webProj;
            IResource res = WebResourcesDecorator.getResource(element);
            WebProject webProject = webProj = res != null && res.getProject() != null && res.isAccessible() ? (WebProject)res.getProject().getNature("com.narucy.webpub.core.publishNature") : null;
            if (webProj != null && (entry = (Object[])this.listenersCache.get(webProj)) == null) {
                Preferences.IPropertyChangeListener listener = new Preferences.IPropertyChangeListener(){

                    public void propertyChange(Preferences.PropertyChangeEvent event) {
                        WebResourcesDecorator.this.refresh(webProj, event.getProperty());
                    }
                };
                webProj.addPropertyChangeListener(listener);
                entry = new Object[4];
                entry[0] = listener;
                this.listenersCache.put(webProj, entry);
            }
            Object[] webProjects = this.listenersCache.keySet().toArray();
            int i = 0;
            while (i < webProjects.length) {
                WebProject wp = (WebProject)webProjects[i];
                Object[] entry2 = (Object[])this.listenersCache.get(wp);
                if (wp.getFolder("htsources_folder").equals((Object)res)) {
                    decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/htsource_folder_ovr.gif"));
                    entry2[1] = res;
                } else if (wp.getFolder("scripts_folder").equals((Object)res)) {
                    decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/scripts_folder_ovr.gif"));
                    entry2[2] = res;
                } else if (wp.getFolder("publish_folder").equals((Object)res)) {
                    decoration.addOverlay(WebpubUIPlugin.getDefault().getImageDescriptor("ovr16/publish_folder_ovr.gif"));
                    entry2[3] = res;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebpubUIPlugin.handleException((Exception)((Object)e));
        }
    }

    void refresh(WebProject wp, String key) {
        Object[] entry = (Object[])this.listenersCache.get(wp);
        if (entry == null) {
            return;
        }
        IContainer container = this.getCachedContainer(wp, key);
        if (container != null) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)container));
        }
        if ((container = wp.getFolder(key)) != null) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)container));
        }
    }

    IContainer getCachedContainer(WebProject wp, String key) {
        Object[] entry = (Object[])this.listenersCache.get(wp);
        int index = WebResourcesDecorator.getKeyIndex(key);
        if (index != -1 && entry[index + 1] != null) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, entry[index + 1]));
        }
        return null;
    }

    static IResource getResource(Object obj) {
        if (obj instanceof IResource) {
            return (IResource)obj;
        }
        if (obj instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public void dispose() {
        Object[] webProjects = this.listenersCache.keySet().toArray();
        int i = 0;
        while (i < webProjects.length) {
            WebProject wp = (WebProject)webProjects[i];
            Object[] entry = (Object[])this.listenersCache.remove(wp);
            wp.removePropertyChangeListener((Preferences.IPropertyChangeListener)entry[0]);
            ++i;
        }
    }
}

