/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.ui;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;

public class HTParser {
    static char[] tagNameEndChars = new char[]{'>', ' ', '\n', '\r', '\t'};

    static {
        Arrays.sort(tagNameEndChars);
    }

    private HTParser() {
    }

    public static boolean isInToken(IDocument doc, int currentOffset) throws BadLocationException {
        int i = currentOffset - 1;
        while (i >= 0) {
            char c = doc.getChar(i);
            if (c == '<' && doc.getChar(i + 1) != '!') {
                return true;
            }
            if (c == '>' && doc.getChar(--i) != '-') {
                return false;
            }
            --i;
        }
        return false;
    }

    public static ITextSelection getElementRange(IDocument doc, int currentOffset) throws BadLocationException {
        return HTParser.getElementRange(doc, currentOffset, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ITextSelection getElementRange(IDocument doc, int offset, int outRange) throws BadLocationException {
        int count = 0;
        while (count < outRange && offset >= 0) {
            if (doc.getChar(offset) == '<' && doc.getChar(offset + 1) != '!') {
                ++count;
            }
            --offset;
        }
        int begin = -1;
        int end = -1;
        int flag = 0;
        boolean inToken = false;
        boolean inEnd = false;
        int i = offset;
        while (i >= 0) {
            block23: {
                char c;
                block25: {
                    block24: {
                        c = doc.getChar(i);
                        if (c != '>' || doc.getChar(i - 1) == '-' || i == offset) break block24;
                        if (doc.getChar(--i) == '/') {
                            while (i > 0 && doc.getChar(--i) != '<' && doc.getChar(i + 1) != '!') {
                            }
                            break block23;
                        } else {
                            inToken = true;
                        }
                        break block23;
                    }
                    if (!inToken) break block25;
                    if (c == '/' && doc.getChar(--i) == '<') {
                        inToken = false;
                        ++flag;
                        break block23;
                    } else if (c == '<' && doc.getChar(i + 1) != '!') {
                        inToken = false;
                        if (flag > 0) {
                            --flag;
                            break block23;
                        } else {
                            begin = i;
                            break;
                        }
                    }
                    break block23;
                }
                if (c == '<' && doc.getChar(i + 1) != '!' && doc.getChar(i + 1) != '/') {
                    begin = i;
                    break;
                }
            }
            --i;
        }
        inToken = false;
        i = begin;
        int len = doc.getLength();
        while (i < len) {
            char c = doc.getChar(i);
            if (!inToken && c == '<' && doc.getChar(i + 1) != '!') {
                inToken = true;
                if (doc.getChar(++i) == '/') {
                    inEnd = true;
                }
            } else if (c == '/' && doc.getChar(++i) == '>') {
                inToken = false;
                if (flag == 0) {
                    end = i + 1;
                    return new TextSelection(doc, begin, end - begin);
                }
            } else if (c == '>' && doc.getChar(i - 1) != '-') {
                if (inEnd) {
                    if (--flag == 0) {
                        end = i + 1;
                        return new TextSelection(doc, begin, end - begin);
                    }
                    inEnd = false;
                } else {
                    ++flag;
                }
                inToken = false;
            }
            ++i;
        }
        return new TextSelection(doc, begin, end - begin);
    }

    public static String getElementName(IDocument doc, int offset) throws BadLocationException {
        return HTParser.chooseElementName(doc, offset, 0);
    }

    public static String chooseElementName(IDocument doc, int offset, int outRange) throws BadLocationException {
        return HTParser.chooseElementName(HTParser.getElementRange(doc, offset, outRange).getText());
    }

    public static String chooseElementName(String line) {
        if (line == null) {
            return null;
        }
        boolean flag = false;
        int b = 0;
        int e = 0;
        int i = 0;
        int len = line.length();
        while (i < len) {
            char c = line.charAt(i);
            if (c == '<') {
                flag = true;
                b = i + 1;
            } else if (flag && Arrays.binarySearch(tagNameEndChars, c) >= 0) {
                e = i;
                break;
            }
            ++i;
        }
        return line.substring(b, e);
    }
}

