/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.linkcheck.core;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.publish.IllegalConfigurationException;
import com.narucy.webpub.core.publish.PublishDescription;
import com.narucy.webpub.core.publish.PublishDescriptionFactory;
import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class LinkCheckConfigurationFactory
implements LinkCheckConstants {
    String[] extensions;

    public LinkCheckConfigurationFactory() {
        this.setExtensions(new String[]{"htm", "html"});
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration(IResource[] resources, boolean convertToPublishLocation) throws CoreException {
        resources = this.surgeryResourceList(resources, convertToPublishLocation);
        String[] resourceLocations = new String[resources.length];
        int i = 0;
        while (i < resourceLocations.length) {
            IResource r = resources[i];
            resourceLocations[i] = r.getLocation().toString();
            ++i;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("com.narucy.webpub.linkcheck");
        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchManager.generateUniqueLaunchConfigurationNameFrom("Link Test"));
        wc.setAttribute("com.narucy.webpub.linkcheck.checkResources", Arrays.asList(resourceLocations));
        wc.setAttribute("com.narucy.webpub.linkcheck.extensions", Arrays.asList(this.extensions));
        wc.setAttribute("com.narucy.webpub.linkcheck.background", true);
        return wc;
    }

    public IResource[] surgeryResourceList(IResource[] rs, boolean convertToPublishLocation) throws CoreException {
        rs = this.removeOverwrap(rs);
        if (convertToPublishLocation) {
            this.convertToPublishLocation(rs);
            rs = this.removeOverwrap(rs);
        }
        this.sortResources(rs);
        return rs;
    }

    boolean anyAdded(List list, IContainer container) throws CoreException {
        IResource[] rs = container.members();
        int j = 0;
        while (j < rs.length) {
            IResource r = rs[j];
            if (!(r instanceof IFile && !this.isCheckFile((IFile)r) || list.contains(r))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    boolean isCheckFile(IFile f) {
        String ext = f.getFileExtension();
        return ext != null && Arrays.binarySearch(this.extensions, ext) >= 0 && f.isAccessible();
    }

    IResource[] removeOverwrap(IResource[] resources) throws CoreException {
        Arrays.sort(resources, new Comparator(){

            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object a, Object b) {
                int sb;
                IPath pa = ((IResource)a).getFullPath();
                IPath pb = ((IResource)b).getFullPath();
                int sa = pa.segmentCount();
                if (sa == (sb = pb.segmentCount())) {
                    int i = 0;
                    while (i < sa) {
                        int v = pa.segment(i).compareTo(pb.segment(i));
                        if (v != 0) {
                            return v;
                        }
                        ++i;
                    }
                    return 0;
                }
                return sa < sb ? 1 : -1;
            }
        });
        ArrayList<IResource> targets = new ArrayList<IResource>(Arrays.asList(resources));
        int i = 0;
        while (i < resources.length) {
            IContainer c = resources[i].getParent();
            if (!targets.contains(c) && this.anyAdded(targets, c)) {
                targets.removeAll(Arrays.asList(c.members()));
                targets.add((IResource)c);
            }
            ++i;
        }
        resources = targets.toArray(new IResource[targets.size()]);
        i = 0;
        while (i < resources.length) {
            IResource r = resources[i];
            if (!r.isAccessible()) {
                targets.remove(r);
            } else if (r instanceof IContainer) {
                this.removeOverrapResources(targets, (IContainer)r);
            } else if (r instanceof IFile && !this.isCheckFile((IFile)r)) {
                targets.remove(r);
            }
            ++i;
        }
        return targets.toArray(new IResource[targets.size()]);
    }

    void sortResources(IResource[] resources) {
        Arrays.sort(resources, new Comparator(){

            public boolean equals(Object obj) {
                return false;
            }

            public int compare(Object a, Object b) {
                if (a.getClass().equals(b.getClass())) {
                    String pa = ((IResource)a).getLocation().toString();
                    String pb = ((IResource)b).getLocation().toString();
                    return pa.compareTo(pb);
                }
                return a instanceof IFile ? 1 : -1;
            }
        });
    }

    void convertToPublishLocation(IResource[] resources) throws CoreException {
        PublishDescriptionFactory fac = PublishDescriptionFactory.getInstance();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            WebProject wp = (WebProject)resource.getProject().getNature("com.narucy.webpub.core.publishNature");
            if (wp != null) {
                if (resource instanceof IContainer) {
                    IContainer pubTarget;
                    IContainer htSourceFolder = wp.getFolder("htsources_folder");
                    IContainer c = pubTarget = (IContainer)resource;
                    while (!(c instanceof IProject)) {
                        if (c.equals((Object)htSourceFolder)) {
                            IPath relPath = pubTarget.getFullPath().removeFirstSegments(htSourceFolder.getFullPath().segmentCount());
                            IFolder folder = wp.getFolder("publish_folder").getFolder(relPath);
                            if (folder.isAccessible()) {
                                resources[i] = folder;
                            }
                            break;
                        }
                        c = c.getParent();
                    }
                } else if (resource instanceof IFile) {
                    IResource r;
                    PublishDescription desc = null;
                    try {
                        desc = fac.create(resource);
                    }
                    catch (IllegalConfigurationException e) {
                        WebpubDebugPlugin.handleException((Exception)((Object)e));
                    }
                    catch (IOException e) {
                        WebpubDebugPlugin.handleException(e);
                    }
                    if (desc != null && (r = desc.getPublishTo()) != null) {
                        resources[i] = r;
                    }
                }
            }
            ++i;
        }
    }

    void removeOverrapResources(List targets, IContainer container) throws CoreException {
        IResource[] rs = container.members();
        int i = 0;
        while (i < rs.length) {
            IResource r = rs[i];
            targets.remove(r);
            if (r instanceof IContainer) {
                this.removeOverrapResources(targets, (IContainer)r);
            }
            ++i;
        }
    }

    public String[] getExtensions() {
        return (String[])this.extensions.clone();
    }

    public void setExtensions(String[] exts) {
        this.extensions = (String[])exts.clone();
        Arrays.sort(this.extensions);
    }
}

