/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.linkcheck.core;

import com.narucy.webpub.debug.WebpubDebugPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

class CheckResoutMonitor {
    IFile checkFile = null;
    ArrayList finishedFiles = new ArrayList();
    ArrayList errorLines = new ArrayList();

    public CheckResoutMonitor(IStreamsProxy proxy) {
        proxy.getOutputStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor streamMonitor) {
                try {
                    CheckResoutMonitor.this.visitLine(text);
                }
                catch (CoreException e) {
                    WebpubDebugPlugin.handleException((Exception)((Object)e));
                }
            }
        });
        proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor streamMonitor) {
                CheckResoutMonitor.this.errorLines.add(text);
            }
        });
    }

    void visitLine(String text) throws CoreException {
        if (this.checkFile != null && text.charAt(0) == '\t') {
            String[] lines = text.split("\n");
            int i = 0;
            while (i < lines.length) {
                String[] entries = lines[i].split(",");
                if (entries.length == 3) {
                    IMarker marker = CheckResoutMonitor.createMarker((IResource)this.checkFile);
                    marker.setAttribute("com.narucy.webpub.debug.core.linkCheck.invalidUrl", (Object)entries[0]);
                    marker.setAttribute("lineNumber", Integer.parseInt(entries[1]));
                    marker.setAttribute("message", (Object)entries[2].trim());
                }
                ++i;
            }
        } else {
            Path fileLocation = new Path(text.trim());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)fileLocation);
            if (file != null) {
                if (this.checkFile != null) {
                    this.finishedFiles.add(this.checkFile);
                }
                this.checkFile = file;
            }
        }
    }

    public IFile getCurrentCheckFile() {
        return this.checkFile;
    }

    public String[] getErrorStreamLines() {
        return this.errorLines.toArray(new String[this.errorLines.size()]);
    }

    public int getFinishedFileCount() {
        return this.finishedFiles.size();
    }

    static IMarker createMarker(IResource f) throws CoreException {
        IMarker m = f.createMarker("org.eclipse.core.resources.problemmarker");
        m.setAttribute("com.narucy.webpub.debug.core.linkCheck", true);
        return m;
    }

    void p(Object o) {
        System.out.println(this.getClass() + ":" + o);
    }
}

