/*
 * Decompiled with CFR 0.152.
 */
package com.narucy.webpub.debug.ui;

import com.narucy.webpub.core.WebProject;
import com.narucy.webpub.core.WebpubPlugin;
import com.narucy.webpub.debug.WebpubDebugPlugin;
import com.narucy.webpub.linkcheck.core.LinkCheckConfigurationFactory;
import com.narucy.webpub.linkcheck.core.LinkCheckConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelectionTab
extends AbstractLaunchConfigurationTab
implements LinkCheckConstants {
    static final ArrayList EMPTY_LIST = new ArrayList();
    LinkCheckConfigurationFactory configFactory = new LinkCheckConfigurationFactory();
    Image iconImage;
    TableViewer resourcesViewer;
    ListViewer extsViewer;
    Button addResourceButton;
    Button removeResourceButton;
    Button addExtsButton;
    Button removeExtsButton;
    SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == ResourceSelectionTab.this.addResourceButton) {
                ResourceSelectionTab.this.handleAddResources();
            }
            if (e.widget == ResourceSelectionTab.this.removeResourceButton) {
                ResourceSelectionTab.this.handleRemoveResources();
            }
            if (e.widget == ResourceSelectionTab.this.addExtsButton) {
                ResourceSelectionTab.this.handleAddExts();
            }
            if (e.widget == ResourceSelectionTab.this.removeExtsButton) {
                ResourceSelectionTab.this.handleRemoveExts();
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };
    public static final IInputValidator FILE_EXTENSION_VALIDATOR = new IInputValidator(){
        char[] invalidChars = "\\/:;*,?<>| \t\r\n".toCharArray();

        public String isValid(String newName) {
            int i = 0;
            while (i < this.invalidChars.length) {
                char ch = this.invalidChars[i];
                if (newName.indexOf(ch) != -1) {
                    return "Invalid char code \"" + ch + "\"";
                }
                ++i;
            }
            if (newName.length() > 0 && newName.charAt(0) == '.') {
                return "Not need to specify first char \".\"";
            }
            return null;
        }
    };

    public void createControl(Composite parent) {
        this.iconImage = WebpubDebugPlugin.getImageDescriptor("ctool16/resources.gif").createImage();
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(1, false));
        new Label(base, 0).setText("Check &Resource:");
        Control resourceBase = this.createResourceSelectionControl(base);
        resourceBase.setLayoutData((Object)new GridData(1808));
        new Label(base, 0).setText("File &Extensions:");
        Control extsBase = this.createExtsSelectionControl(base);
        extsBase.setLayoutData((Object)new GridData(768));
        this.setControl((Control)base);
    }

    Control createResourceSelectionControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.resourcesViewer = new TableViewer(base);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.resourcesViewer.getControl().setLayoutData((Object)gd);
        this.resourcesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resourcesViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                if (element instanceof IResource) {
                    return ((IResource)element).getLocation().toString();
                }
                return input;
            }
        });
        this.addResourceButton = this.createButton(base, "&Add");
        this.removeResourceButton = this.createButton(base, "&Remove");
        this.removeResourceButton.setEnabled(false);
        this.resourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSelectionTab.this.removeResourceButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return base;
    }

    Control createExtsSelectionControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout(2, false));
        this.extsViewer = new ListViewer(base);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.extsViewer.getControl().setLayoutData((Object)gd);
        this.extsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.addExtsButton = this.createButton(base, "A&dd");
        this.removeExtsButton = this.createButton(base, "R&emove");
        this.removeExtsButton.setEnabled(false);
        this.extsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSelectionTab.this.removeExtsButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return base;
    }

    Button createButton(Composite parent, String name) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.addSelectionListener(this.buttonListener);
        button.setLayoutData((Object)new GridData(258));
        return button;
    }

    IResource[] getSelectedResource() {
        List rs = ((IStructuredSelection)this.resourcesViewer.getSelection()).toList();
        return rs.toArray(new IResource[rs.size()]);
    }

    void handleAddResources() {
        ResourceSelectionDialog dialog = new ResourceSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), "Select to check resources");
        if (dialog.open() == 0) {
            Object[] rs = dialog.getResult();
            this.addResources(Arrays.asList(rs));
        }
    }

    void addResources(List rs) {
        this.addResources(rs.toArray(new IResource[rs.size()]));
    }

    void addResources(IResource[] rs) {
        ArrayList list = (ArrayList)this.resourcesViewer.getInput();
        int i = 0;
        while (i < rs.length) {
            if (!list.contains(rs[i])) {
                list.add(rs[i]);
            }
            ++i;
        }
        rs = list.toArray(new IResource[list.size()]);
        try {
            rs = this.configFactory.surgeryResourceList(rs, true);
            this.resourcesViewer.setInput(new ArrayList<IResource>(Arrays.asList(rs)));
        }
        catch (CoreException e) {
            WebpubPlugin.handleException((Exception)((Object)e));
        }
        this.setDirty(true);
        this.resourcesViewer.refresh();
        this.getLaunchConfigurationDialog().updateButtons();
    }

    void handleRemoveResources() {
        IResource[] rs = this.getSelectedResource();
        ArrayList list = (ArrayList)this.resourcesViewer.getInput();
        int i = 0;
        while (i < rs.length) {
            list.remove(rs[i]);
            ++i;
        }
        this.setDirty(true);
        this.resourcesViewer.setInput((Object)list);
        this.resourcesViewer.refresh();
        this.getLaunchConfigurationDialog().updateButtons();
    }

    void handleAddExts() {
        InputDialog input = new InputDialog(this.getShell(), "File Extension", "Input to check target that is workbench resources extension", null, FILE_EXTENSION_VALIDATOR);
        if (input.open() == 0) {
            String[] exts = this.configFactory.getExtensions();
            String[] newExts = new String[exts.length + 1];
            System.arraycopy(exts, 0, newExts, 0, exts.length);
            newExts[newExts.length - 1] = input.getValue();
            this.setExtensions(newExts);
        }
    }

    void setExtensions(List newExts) {
        this.setExtensions(newExts.toArray(new String[newExts.size()]));
    }

    void setExtensions(String[] newExts) {
        this.configFactory.setExtensions(newExts);
        this.extsViewer.setInput((Object)newExts);
        this.extsViewer.refresh();
        this.refreshResourceList();
    }

    void handleRemoveExts() {
        ArrayList<String> exts = new ArrayList<String>(Arrays.asList(this.configFactory.getExtensions()));
        exts.removeAll(((IStructuredSelection)this.extsViewer.getSelection()).toList());
        this.setExtensions(exts);
    }

    void refreshResourceList() {
        this.addResources(new IResource[0]);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        ArrayList<String> defaultResources = new ArrayList<String>();
        try {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                WebProject wp = (WebProject)projects[i].getNature("com.narucy.webpub.core.publishNature");
                if (wp != null) {
                    defaultResources.add(wp.getFolder("publish_folder").getLocation().toString());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            WebpubDebugPlugin.handleException((Exception)((Object)e));
        }
        wc.setAttribute("com.narucy.webpub.linkcheck.checkResources", defaultResources);
        wc.setAttribute("com.narucy.webpub.linkcheck.extensions", Arrays.asList("html", "htm"));
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        try {
            List resources = conf.getAttribute("com.narucy.webpub.linkcheck.checkResources", (List)EMPTY_LIST);
            ArrayList<IFile> rs = new ArrayList<IFile>();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < resources.size()) {
                Path path = new Path((String)resources.get(i));
                IFile r = root.getFileForLocation((IPath)path);
                if (r == null || !r.isAccessible()) {
                    r = root.getContainerForLocation((IPath)path);
                }
                if (r != null && r.isAccessible()) {
                    rs.add(r);
                }
                ++i;
            }
            this.resourcesViewer.setInput(rs);
            List exts = conf.getAttribute("com.narucy.webpub.linkcheck.extensions", (List)EMPTY_LIST);
            this.setExtensions(exts);
        }
        catch (CoreException e) {
            WebpubDebugPlugin.handleException((Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList resourceList = (ArrayList)this.resourcesViewer.getInput();
        int i = 0;
        while (i < resourceList.size()) {
            IResource r = (IResource)resourceList.get(i);
            locations.add(r.getLocation().toString());
            ++i;
        }
        wc.setAttribute("com.narucy.webpub.linkcheck.checkResources", locations);
    }

    public String getName() {
        return "&Target Resources";
    }

    public Image getImage() {
        return this.iconImage;
    }

    public void dispose() {
        if (this.iconImage != null) {
            this.iconImage.dispose();
        }
        super.dispose();
    }
}

