/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import org.infodb.commons.db.SQLDML;
import org.infodb.commons.db.SQLLog;

public class SQLPrepare
extends SQLDML {
    private Connection conn;
    private PreparedStatement stmt;
    private HashMap<String, SQLDML.FieldPair> mapFields;
    private boolean needClose;

    public SQLPrepare(Connection c) {
        this.conn = c;
        this.needClose = true;
    }

    public SQLPrepare(Connection c, boolean close) {
        this.conn = c;
        this.needClose = close;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void close() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.needClose) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void addColumn(String name) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, null);
        this.columns.add(fp);
        this.mapFields.put(name, fp);
    }

    public void addColumnWithFunc(String name, String func) {
        SQLDML.FieldPair fp = new SQLDML.FieldPair(name, func);
        this.columns.add(fp);
        this.mapFields.put(name, fp);
    }

    public void prepareInsert() throws SQLException {
        String sql = this.generateInsertSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
    }

    public void prepareUpdate() throws SQLException {
        String sql = this.generateUpdateSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
    }

    public void prepareDelete() throws SQLException {
        String sql = this.generateDeleteSQL();
        SQLLog.sqllog(sql);
        this.stmt = this.conn.prepareStatement(sql);
    }

    public SQLDML.FieldPair getFieldPair(String name) {
        return this.mapFields.get(name);
    }

    public boolean execute() throws SQLException {
        int index = this.paramSetting(this.stmt, 1);
        this.whereSetting(this.stmt, index);
        return this.stmt.execute();
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            SQLLog.error(e);
        }
    }
}

