// $Id: CViewer.h,v 1.10 2003/04/13 13:42:14 ta_muto Exp $
// Viewer functional class inherited from Ver 1.x. 
// It does not implement the ITask class. it is because the call from an external session was forbidden.

#ifndef __wax_CViewer_h
#define __wax_CViewer_h

#include <common.h>
#include <collection.h>
#include <IDispatch.h>
#include <CEnvironment.h>
#include <views/ITask.h>

namespace wax {
	class CViewer : public IDispatch {
		CCollection headList;
		CCollection taskList;
	public:
		CViewer() { }
		~CViewer();
		
		bool parse(CEnvironment* runenv, xmlNodePtr cur);
		bool execute();
		void output(IWriter* writer);
	protected:
		bool parseInternal(CEnvironment* runenv, xmlNodePtr cur, xmlNsPtr ns);
		bool isDisposed() { return taskList.hasItem(); }
	public:
		static ITask* findTask(xmlNodePtr cur, bool& bodyPart);
	} ;
}

#endif
