// $Id: CScriptlet.cc,v 1.7 2003/05/10 06:46:48 ta_muto Exp $

#include <CScriptlet.h>
#include <views/CViewer.h>
#include <templates/CTemplate.h>
#include <xupdate/CListener.h>

wax::IDispatch* wax::CScriptlet::parse(CEnvironment* runenv)
{
	xmlNodePtr root = runenv->getRootNodePtr();
	xmlNsPtr ns = xmlSearchNsByHref(runenv->getDocPtr(), root, CEnvironment::WAX);
	if(ns != NULL) {
		if(!xmlStrcmp(root->name, (const xmlChar*)"viewer")) {
			CViewer* view = new CViewer();
			if(view->parse(runenv, root) == false) {
				delete view;
				return NULL;
			}
			return view;
		} else if(!xmlStrcmp(root->name, (const xmlChar*)"template")) {
			if(runenv->getStartFlag() == true) {
				CXmlStr flag(xmlGetProp(root, (const xmlChar*) "enable-direct-call"));
				bool b = checkBoolean(flag.value(), false);
				if(b == false) {
					IError::message(ERR_NOCALLTEMPLATE);
					return NULL;
				}
			}
			CTemplate* templ = new CTemplate();
			if(templ->parse(runenv, root) == false) {
				delete templ;
				return NULL;
			}
			return templ;
// not supported yet.
/*
		} else if(!xmlStrcmp(root->name, (const xmlChar*)"listener")) {
			CListener* listn = new CListener();
			if(listn->parse(runenv, root) == false) {
				delete listn;
				return NULL;
			}
			return listn;
*/
		}
	}
	if(root->ns == NULL) {
		IError::message(ERR_NOTSUPPORTED, "%s", root->name);
	} else {
		IError::message(ERR_NOTSUPPORTED, "%s:%s", root->ns->prefix, root->name);
	}
	return NULL;
}
