// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.geom.Vector3D;
import flash.geom.Matrix3D;
import flash.display3D.textures.Texture;

class SimpleShaderUV extends hxsl.Shader {
  static public var id:String = "SimpleShaderUV";
  static var SRC = {
    var input : {
      pos:Float3,
      uv:Float2,
    };
    var tuv:Float2;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      out = input.pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      tuv = input.uv;
    }
    function fragment( tex:Texture ) {
      var t = tex.get( tuv );
      out = [ t.x, t.y, t.z, 1.0 ];
    }
  };
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      texture:Texture ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.offset = vo;
    this.tex = texture;
  }
}
