// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

class SimpleShader extends hxsl.Shader {
  static public var id:String = "SimpleShader";
  static var SRC = {
    var input : {
      pos:Float3,
      col:Float3,
    };
    var color:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      out = input.pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      color = input.col;
    }
    function fragment( alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  };
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      a:Float ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.offset = vo;
    this.alpha = a;
  }
}
