// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// a triangle and uv coordinate of its vertexes

class Face {
  @:isVar public var ids( get, set ):TriFaceIDs; // vertex ids
    public function get_ids():TriFaceIDs { return( ids ); }
    public function set_ids( i:TriFaceIDs ):TriFaceIDs {
      ids = i.clone();
      return( ids );
    }
  @:isVar public var uv0( get, set ):UVCoord;
    public function get_uv0():UVCoord { return( uv0 ); }
    public function set_uv0( r:UVCoord ):UVCoord {
      uv0 = r.clone();
      return( uv0 );
    }
  @:isVar public var uv1( get, set ):UVCoord;
    public function get_uv1():UVCoord { return( uv1 ); }
    public function set_uv1( r:UVCoord ):UVCoord {
      uv1 = r.clone();
      return( uv1 );
    }
  @:isVar public var uv2( get, set ):UVCoord;
    public function get_uv2():UVCoord { return( uv2 ); }
    public function set_uv2( r:UVCoord ):UVCoord {
      uv2 = r.clone();
      return( uv2 );
    }

  // ##################################################################

  public function new( ?i:UInt,
                       ?j:UInt,
                       ?k:UInt,
                       ?r0:UVCoord,
                       ?r1:UVCoord,
                       ?r2:UVCoord ) {
    if ( i != null && j != null && k != null ) {
      ids = new TriFaceIDs( i, j, k );
    }
    if ( r0 != null ) uv0 = r0;
    if ( r1 != null ) uv1 = r1;
    if ( r2 != null ) uv2 = r2;
  }

  public function setID( i:UInt,
                         j:UInt,
                         k:UInt ):Void {
    ids = new TriFaceIDs( i, j, k );
  }
}
