// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

class SecondaryType {
  static public var COIL( default, null ):Int = -1;
  static public var NONE( default, null ):Int = 0; // for heteros
  static public var HELIX_ALPHA( default, null ):Int = 1;
  static public var HELIX_3_10( default, null ):Int = 2;
  static public var HELIX_PI( default, null ):Int = 3;
  static public var TURN( default, null ):Int = 4;
  static public var BRIDGE( default, null ):Int = 5;
  static public var STRAND( default, null ):Int = 6;

  static public function toString( t:Int ):String {
    switch ( t ) {
      case SecondaryType.HELIX_ALPHA,
           SecondaryType.HELIX_3_10,
           SecondaryType.HELIX_PI:
        return( "HELIX" );
      case SecondaryType.STRAND:
        return( "STRAND" );
      case SecondaryType.COIL,
           SecondaryType.BRIDGE:
        return( "COIL" );
    }
    return( "" );
  }

  static public function toChar( t:Int ):String {
    switch ( t ) {
      case SecondaryType.HELIX_ALPHA:
        return( "H" );
      case SecondaryType.HELIX_3_10:
        return( "3" );
      case SecondaryType.HELIX_PI:
        return( "P" );
      case SecondaryType.STRAND:
        return( "E" );
      case SecondaryType.COIL:
        return( "C" );
      case SecondaryType.TURN:
        return( "T" );
      case SecondaryType.BRIDGE:
        return( "B" );
    }
    return( "-" );
  }
}
