// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// available secondary structure names are
// listed in SecondaryType.hx

class PdbSecondary {
  static public function readHelixFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 21, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 19, 1 );
    return( new PdbSecondary( i, l, c, SecondaryType.HELIX_ALPHA ) );
  }

  static public function readStrandFromText( text:String ):PdbSecondary {
    var i:Int = Std.parseInt( text.substr( 22, 4 ) );
    var l:Int = Std.parseInt( text.substr( 33, 4 ) );
    var c:String = text.substr( 21, 1 );
    return( new PdbSecondary( i, l, c, SecondaryType.STRAND ) );
  }

  // #####################################################################
  @:isVar public var init( get, set ):Int;
    public function get_init():Int { return( init ); }
    public function set_init( i:Int ):Int { init = i; return( init ); }
  @:isVar public var last( get, set ):Int;
    public function get_last():Int { return( last ); }
    public function set_last( l:Int ):Int { last = l; return( last ); }
  @:isVar public var sectype( get, set ):Int;
    public function get_sectype():Int { return( sectype ); }
    public function set_sectype( t:Int ):Int {
      sectype = t;
      return( sectype );
    }
  @:isVar public var chainid( get, set ):String;
    public function get_chainid():String { return( chainid ); }
    public function set_chainid( i:String ):String { chainid = i; return( chainid ); }

  // ########################################################################

  public function new( ?i:Int,
                       ?l:Int,
                       ?c:String,
                       ?st:Int ) {
    if ( i != null ) init = i;
    if ( l != null ) last = l;
    if ( c != null ) chainid = c;
    if ( st != null ) sectype = st;
  }
}
