// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMRibbon extends WMObjBase {
  @:isVar public var isRibbon( get, set ):Bool;
    public function get_isRibbon():Bool { return( isRibbon ); }
    public function set_isRibbon( i:Bool ):Bool {
      isRibbon = i;
      return( isRibbon );
    }

  @:isVar public var initXML( get, set ):Int;
    public function get_initXML():Int { return( initXML ); }
    public function set_initXML( n:Int ):Int {
      initXML = n;
      return( initXML );
    }
  @:isVar public var lastXML( get, set ):Int;
    public function get_lastXML():Int { return( lastXML ); }
    public function set_lastXML( n:Int ):Int {
      lastXML = n;
      return( lastXML );
    }
  @:isVar public var init( get, set ):Int;
    public function get_init():Int { return( init ); }
    public function set_init( n:Int ):Int {
      init = n;
      return( init );
    }
  @:isVar public var last( get, set ):Int;
    public function get_last():Int { return( last ); }
    public function set_last( n:Int ):Int {
      last = n;
      return( last );
    }
  @:isVar public var thickness( get, set ):Float;
    public function get_thickness():Float { return( thickness ); }
    public function set_thickness( t:Float ):Float {
      thickness = t;
      return( thickness );
    }
  @:isVar public var smoothing( get, set ):Bool;
    public function get_smoothing():Bool { return( smoothing ); }
    public function set_smoothing( b:Bool ):Bool {
      smoothing = b;
      return( smoothing );
    }

  // ####################################################################

  public function new( ?i:Bool = false,
                       ?r:Float = 3.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.6,
                       ?sp:Float = 0.3,
                       ?gl:Float = 30.0,
                       ?sh:String = "Phong" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
    isRibbon = i;
    initXML = lastXML = -1;
    init = last = -1;
    thickness = 0.0;
    smoothing = false;
  }

  public function clone():WMRibbon {
    var ret:WMRibbon = new WMRibbon( isRibbon, radius, color0, color1, alpha, offset, quality, ambient, diffuse, specular, gloss, shader );
    ret.init = init;
    ret.initXML = initXML;
    ret.last = last;
    ret.lastXML = lastXML;
    ret.thickness = thickness;
    ret.smoothing = smoothing;
    return( ret );
  }

  public override function clear( ?def:WMDefaults = null ):Void {
    if ( def != null ) {
      if ( isRibbon ) {
        copyFrom( def.Ribbon );
        thickness = def.RibbonThickness;
        smoothing = def.RibbonSmoothing;
      } else {
        copyFrom( def.Coil );
      }
    } else {
      isRibbon = false;
      radius = 3.0;
      color0 = 0x00FF00;
      color1 = 0x00FF00;
      alpha = 1.0;
      offset = 0.0;
      quality = 0;
      ambient = 0.3;
      diffuse = 0.6;
      specular = 0.3;
      gloss = 30.0;
      shader = "Gouraud";
      thickness = 0.0;
      smoothing = false;
    }
    _polygon = null;
    initXML = lastXML = -1;
  }

  public override function loadFromXml( x:Xml,
                                        ?def:WMDefaults = null ):Void {
    clear( def );
    loadFromXmlWOClear( x );
  }

  public function loadFromXmlOverwrite( x:Xml ):Void {
    super.loadFromXml( x );
    var strs = [ "thick", "thickness" ];
    for ( str in strs ) {
      if ( x.exists( str ) ) {
        thickness = Std.parseFloat( x.get( str ) );
      }
    }
    var strs = [ "smooth", "smoothing" ];
    for ( str in strs ) {
      if ( x.exists( str ) ) {
        smoothing = ( Std.parseInt( x.get( str ) ) > 0 );
      }
    }
  }

  // what a ad hoc function...
  public function loadFromXmlWOClear( x:Xml ):Void {
    loadFromXmlOverwrite( x );
    if ( !x.exists( "init" ) || !x.exists( "last" ) ) {
      trace( "init and last attributes are required for a RIBBON or COIL element" );
      return;
    }
    initXML = Std.parseInt( x.get( "init" ) );
    lastXML = Std.parseInt( x.get( "last" ) );
  }

  public function gen( c:Context3D,
                       chain:SmoothChain,
                       ?is_dc_active:Bool = false ):Void {
    pregen( chain );
    gen2( c, is_dc_active );
  }

  public function pregen( chain:SmoothChain ) {
    if ( color0 != color1 ) {
      if ( shader == "Gouraud" ) shader = "GouraudUV";
      if ( shader == "Phong" ) shader = "PhongUV";
    }
    if ( isRibbon ) {
      _polygon = chain.genRibbon( WMBase.getRelative( radius ),
                                  WMBase.getRelative( thickness ),
                                  init, last + 1, smoothing );
    } else {
      _polygon = chain.genCoil( WMBase.getRelative( radius ), quality,
                                init, last + 1 );
    }
    setShaderParams();
  }

  public function gen2( c:Context3D,
                        ?is_dc_active:Bool = false ) {
    _polygon.allocate( c, is_dc_active, shader, color0, alpha );
    // replace texture if neccessary
    if ( color0 != color1 ) {
      _polygon.createGradientTexture( c, color0, color1 );
    }
  }
}
