// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

import flash.text.TextField;
import flash.text.TextFormat;
import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMLabel extends WMObjBase {
  @:isVar public var font( get, set ):String;
    public function get_font():String { return( font ); }
    public function set_font( fn:String ):String {
      font = fn;
      return( font );
    }
  @:isVar public var fontsize( get, set ):Float;
    public function get_fontsize():Float { return( fontsize ); }
    public function set_fontsize( fs:Float ):Float {
      fontsize = fs;
      return( fontsize );
    }
  @:isVar public var text( get, set ):String;
    public function get_text():String { return( text ); }
    public function set_text( t:String ):String {
      text = t;
      return( t );
    }
  @:isVar public var pos( get, set ):Point3D;
    public function get_pos():Point3D { return( pos ); }
    public function set_pos( p:Point3D ):Point3D {
      if ( p != null ) pos = p.clone();
      return( pos );
    }
  @:isVar public var opos( get, set ):Point3D;
    public function get_opos():Point3D { return( opos ); }
    public function set_opos( p:Point3D ):Point3D {
      if ( p != null ) opos = p.clone();
      return( opos );
    }

  // ####################################################################

  public function new( ?r:Float = 130.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.0,
                       ?d:Float = 0.0,
                       ?sp:Float = 0.0,
                       ?gl:Float = 20.0,
                       ?sh:String = "2DUV" ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
    pos = null;
    opos = null;
    font = "Arial";
    fontsize = 32.0;
    text = "";
  }

  public function clone():WMLabel {
    var ret:WMLabel = new WMLabel( radius, color0, color1, alpha, offset, quality, ambient, diffuse, specular, gloss, shader );
    ret.font = font;
    ret.fontsize = fontsize;
    return( ret );
  }

  public override function clear( ?def:WMDefaults = null ):Void {
    if ( def != null ) {
      copyFrom( def.Label );
      font = def.LabelFont;
      fontsize = def.LabelSize;
    } else {
      radius = 130.0;
      alpha = 1.0;
      font = "Arial";
      fontsize = 32.0;
    }
    pos = null;
    opos = null;
    text = "";
    _polygon = null;
  }

  public override function loadFromXml( x:Xml,
                                        ?def:WMDefaults = null ):Void {
    clear( def );
    loadFromXmlWOClear( x );
  }

  public function loadFromXmlOverwrite( x:Xml ):Void {
    super.loadFromXml( x );
    if ( x.exists( "font" ) ) font = x.get( "font" );
    if ( x.exists( "fontsize" ) ) fontsize = Std.parseFloat( x.get( "fontsize" ) );
    shader = "2DUV"; // only applicable shader
  }

  public function loadFromXmlWOClear( x:Xml ):Void {
    loadFromXmlOverwrite( x );
    if ( !x.exists( "pos" ) || !x.exists( "text" ) ) {
      trace( "pos and text attributes are required for a LABEL element." );
      return;
    }
    pos = Point3D.fromStringInverted( x.get( "pos" ) );
    opos = pos;
    text = x.get( "text" );
  }

  public function gen( c:Context3D,
                       ?is_dc_active = false ):Void {
    pregen();
    gen2( c, is_dc_active );
  }

  public function pregen() {}

  public function gen2( c:Context3D,
                        ?is_dc_active = false ) {
    var tf:TextField = new TextField();
    tf.text = text;
    tf.autoSize = flash.text.TextFieldAutoSize.LEFT;
    tf.selectable = false;
    // larger font size might be better to draw smooth character
    tf.setTextFormat( new TextFormat( font, fontsize, color0, true, null, null, null, flash.text.TextFormatAlign.LEFT ) );
    var aspect:Float = tf.width / tf.height;
    //_polygon = new Text3D( tf.width * scale, tf.height * scale );
    // ad hoc scaling for width
    _polygon = new Text3D( 0.75 * aspect * radius, radius );
    _polygon.translate( pos.x, pos.y, pos.z );
    _polygon.createTextTexture( c, tf );
    _polygon.allocate( c, is_dc_active, shader, color0, alpha );
  }

  public function num():Int { return(1); }
  public function sumPos():Point3D { return( pos ); }
  public function translate( p:Point3D ):Void { pos.add( p ); }
  public function absmax():Point3D {
    return( new Point3D( Math.abs( pos.x ), Math.abs( pos.y ), Math.abs( pos.z ) ) );
  }
  public function scaleCoord( scale:Float ):Void {
    pos.multiply( scale );
  }
  public override function getDataSize():Int { return(3); }
}
