// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// simple container for a control point in chain
//
// this class contains: 
//   * position of the control/interpolated point
//   * original position of control point
//   * direction of the face

class WMCPoint {
  @:isVar public var pos( get, set ):Point3D;
    public function get_pos():Point3D { return( pos ); }
    public function set_pos( p:Point3D ):Point3D {
      pos = p.clone();
      opos =  p;
      return( pos );
    }
  @:isVar public var opos( get, set ):Point3D;
    public function get_opos():Point3D { return( opos ); }
    public function set_opos( p:Point3D ):Point3D {
      opos = p.clone();
      return( opos );
    }
  @:isVar public var facedir( get, set ):Point3D;
    public function get_facedir():Point3D { return( facedir ); }
    public function set_facedir( f:Point3D ):Point3D {
      facedir = f.clone();
      return( facedir );
    }

  // #######################################################################

  public function new( ?p:Point3D = null,
                       ?f:Point3D = null ) {
    if ( p != null ) pos = p;
    if ( f != null ) facedir = f;
  }

  public function clone():WMCPoint {
    return( new WMCPoint( pos, facedir ) );
  }
}
