// container for default values for each <SCENE>
class WMDefaults {
  public var Atom( __getAtomDef, __setAtomDef ):WMBase;

  public var Bond( __getBondDef, __setBondDef ):WMBase;
  public var BondRound( __getBondRoundDef, __setBondRoundDef ):Bool;
  public var BondExclude( __getBondExcludeDef, __setBondExcludeDef ):Bool;
  public var BondDashed( __getBondDashedDef, __setBondDashedDef ):Int;

  public var Coil( __getCoilDef, __setCoilDef ):WMBase;

  public var Ribbon( __getRibbonDef, __setRibbonDef ):WMBase;

  public var Label( __getLabelDef, __setLabelDef ):WMBase;
  public var LabelFont( __getLabelFontDef, __setLabelFontDef ):String;
  public var LabelSize( __getLabelSizeDef, __setLabelSizeDef ):Float;

  public var Shape( __getShapeDef, __setShapeDef ):WMBase;

  public var Object3D( __getObject3DDef, __setObject3DDef ):WMBase;
  public var Object3DType( __getObject3DTypeDef, __setObject3DTypeDef ):String;

  public function new() {
    Atom = new WMBase( 4.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.7,
                       0.8, 20, "Phong" );
    Bond = new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 1.0,
                       0.6, 20, "Gouraud" );
    BondRound = false;
    BondExclude = false;
    BondDashed = 0;
    Ribbon = new WMBase( 8.0, 0xFF0000, 0xFF0000, 1.0, 0.0, 0, 0.3, 0.7,
                         0.8, 10, "Phong" );
    Coil = new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.7,
                       0.8, 10, "Gouraud" );
    Label = new WMBase( 130.0, 0x000000, 0x000000, 1.0, 0.0, 0, 0.0, 0.0,
                        0.0, 20, "2DUV" );
    LabelFont = "Arial";
    LabelSize = 32.0;
    Shape = new WMBase( 0.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.5,
                        0.2, 20.0, "Phong" );
    Object3D = new WMBase( 1.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 3, 0.35, 0.7,
                           0.8, 20, "Phong" );
    Object3DType = "cone";
  }

  // getter
  public function __getAtomDef():WMBase { return( Atom ); }
  public function __getBondDef():WMBase { return( Bond ); }
  public function __getBondRoundDef():Bool { return( BondRound ); }
  public function __getBondExcludeDef():Bool { return( BondExclude ); }
  public function __getBondDashedDef():Int { return( BondDashed ); }
  public function __getCoilDef():WMBase { return( Coil ); }
  public function __getRibbonDef():WMBase { return( Ribbon ); }
  public function __getLabelDef():WMBase { return( Label ); }
  public function __getLabelFontDef():String { return( LabelFont ); }
  public function __getLabelSizeDef():Float { return( LabelSize ); }
  public function __getShapeDef():WMBase { return( Shape ); }
  public function __getObject3DDef():WMBase { return( Object3D ); }
  public function __getObject3DTypeDef():String { return( Object3DType ); }
  // setter
  public function __setAtomDef( a:WMBase ):WMBase {
    if ( Atom == null ) Atom = new WMBase();
    Atom.copyFrom( a );
    return( Atom );
  }
  public function __setBondDef( b:WMBase ):WMBase {
    if ( Bond == null ) Bond = new WMBase();
    Bond.copyFrom( b );
    return( Bond );
  }
  public function __setBondRoundDef( f:Bool ):Bool {
    BondRound = f;
    return( BondRound );
  }
  public function __setBondExcludeDef( f:Bool ):Bool {
    BondExclude = f;
    return( BondExclude );
  }
  public function __setBondDashedDef( d:Int ):Int {
    BondDashed = d;
    return( BondDashed );
  }
  public function __setCoilDef( c:WMBase ):WMBase {
    if ( Coil == null ) Coil = new WMBase();
    Coil.copyFrom( c );
    return( Coil );
  }
  public function __setRibbonDef( r:WMBase ):WMBase {
    if ( Ribbon == null ) Ribbon = new WMBase();
    Ribbon.copyFrom( r );
    return( Ribbon );
  }
  public function __setLabelDef( l:WMBase ):WMBase {
    if ( Label == null ) Label = new WMBase();
    Label.copyFrom( l );
    return( Label );
  }
  public function __setLabelFontDef( f:String ):String {
    LabelFont = f;
    return( LabelFont );
  }
  public function __setLabelSizeDef( s:Float ):Float {
    LabelSize = s;
    return( LabelSize );
  }
  public function __setShapeDef( s:WMBase ):WMBase {
    if ( Shape == null ) Shape = new WMBase();
    Shape.copyFrom( s );
    return( Shape );
  }
  public function __setObject3DDef( o:WMBase ):WMBase {
    if ( Object3D == null ) Object3D = new WMBase();
    Object3D.copyFrom( o );
    return( Object3D );
  }
  public function __setObject3DTypeDef( t:String ):String {
    Object3DType = t;
    return( Object3DType );
  }
}
