class Shader2D extends format.hxsl.Shader {
  static public var id:String = "2DShader";
  static var SRC = {
    var input : {
      pos:Float3,
    };
    function vertex( mpos:M44,
                     mproj:M44,
                     origin:Float4 ) {
      out = pos.xyzw + origin * mpos * mproj;
    }
    function fragment( color:Float3,
                       alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  }
}
