class PhongShader extends format.hxsl.Shader {
  static public var id:String = "PhongShader";
  static var SRC = {
    var input : {
      pos:Float3,
      norm:Float3,
    }
    var position:Float3;
    var normal:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      position = pos * mpos * mproj + offset;
      normal = norm * mpos;
      out = pos.xyzw * mpos * mproj + offset.xyzz;
    }
    function fragment( light:Float3,
                       cpos:Float3,
                       ambient:Float,
                       diffuse:Float,
                       specular:Float,
                       gloss:Float,
                       col:Float3,
                       alpha:Float ) {
      var tnorm = normalize( normal );
      var lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      // specular using half vector
      var view = normalize( sub( cpos, position ) );
      var half = normalize( add( light, view ) );
      var spow = specular * pow( max( 0, dot( half, tnorm ) ), gloss );
      out = [ spow + col.x * lpow, spow + col.y * lpow, spow + col.z * lpow, alpha ];
    }
  };
}
