import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMShape extends WMObjBase {
  static public var defaults:WMBase
      = new WMBase( 0.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.5,
                    0.2, 20.0, "Phong" );

  public var posstr0( null, null ):Array< String >;
  public var posstr1( null, null ):Array< String >;
  public var posstr2( null, null ):Array< String >;

  public function new( ?r:Float = 0.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 1.0,
                       ?sp:Float = 0.6,
                       ?gl:Float = 20.0 ) {
    super( r, c0, c1, a, o, q, ag, sp, gl );
    posstr0 = new Array< String >();
    posstr1 = new Array< String >();
    posstr2 = new Array< String >();
  }

  public override function clear():Void {
    copyFrom( WMShape.defaults );
    _polygon = new Triangles();
    posstr0 = [];
    posstr1 = [];
    posstr2 = [];
  }

  private override function __myLoadFromXml( x:Xml ):Void {
    for ( elem in x.elementsNamed( "TRI" ) ) {
      if ( !elem.exists( "p0" ) ||
           !elem.exists( "p1" ) ||
           !elem.exists( "p2" ) ) {
        trace( "p0, p1, and p2 are required for TRI" );
        return;
      }
      posstr0.push( elem.get( "p0" ) );
      posstr1.push( elem.get( "p1" ) );
      posstr2.push( elem.get( "p2" ) );
    }
  }

  public function gen( c:Context3D ):Void {
    _polygon = new Triangles();
    var len:Int = posstr0.length;
    for ( i in 0 ... len ) {
      _polygon.registerFace( posstr0[i], posstr1[i], posstr2[i] );
    }
    _polygon.allocate( c, shader, color0, alpha );
  }

  public function getPositions0():Array< Point3D > {
    var ret = new Array< Point3D >();
    for ( str in posstr0 ) {
      ret.push( Point3D.fromString( str ) );
    }
    return( ret );
  }

  public function getPositions1():Array< Point3D > {
    var ret = new Array< Point3D >();
    for ( str in posstr1 ) {
      ret.push( Point3D.fromString( str ) );
    }
    return( ret );
  }

  public function getPositions2():Array< Point3D > {
    var ret = new Array< Point3D >();
    for ( str in posstr2 ) {
      ret.push( Point3D.fromString( str ) );
    }
    return( ret );
  }

  public function setPositions0( ar:Array< Point3D > ):Void {
    posstr0 = [];
    for ( pos in ar ) posstr0.push( pos.toString() );
  }

  public function setPositions1( ar:Array< Point3D > ):Void {
    posstr1 = [];
    for ( pos in ar ) posstr1.push( pos.toString() );
  }

  public function setPositions2( ar:Array< Point3D > ):Void {
    posstr2 = [];
    for ( pos in ar ) posstr2.push( pos.toString() );
  }

  public function num():Int { return( posstr0.length * 3 ); }
  public function sumPos():Point3D {
    var ret:Point3D = new Point3D( 0, 0, 0 );
    for ( p in posstr0 ) ret.add( Point3D.fromString( p ) );
    for ( p in posstr1 ) ret.add( Point3D.fromString( p ) );
    for ( p in posstr2 ) ret.add( Point3D.fromString( p ) );
    return( ret );
  }

  public function absmax():Point3D {
    var ret:Point3D = new Point3D( 0, 0, 0 );
    for ( p in posstr0 ) {
      var pos:Point3D = Point3D.fromString( p );
      ret.x = Math.max( ret.x, Math.abs( pos.x ) );
      ret.y = Math.max( ret.y, Math.abs( pos.y ) );
      ret.z = Math.max( ret.z, Math.abs( pos.z ) );
    }
    for ( p in posstr1 ) {
      var pos:Point3D = Point3D.fromString( p );
      ret.x = Math.max( ret.x, Math.abs( pos.x ) );
      ret.y = Math.max( ret.y, Math.abs( pos.y ) );
      ret.z = Math.max( ret.z, Math.abs( pos.z ) );
    }
    for ( p in posstr2 ) {
      var pos:Point3D = Point3D.fromString( p );
      ret.x = Math.max( ret.x, Math.abs( pos.x ) );
      ret.y = Math.max( ret.y, Math.abs( pos.y ) );
      ret.z = Math.max( ret.z, Math.abs( pos.z ) );
    }
    return( ret );
  }
}
