import flash.display3D.Context3D;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

class WMChain {
  public var chain( __getChain, null ):SmoothChain;
  public var ribbons( __getRibbons, null ):Array< WMRibbon >;
  public var coils( __getCoils, null ):Array< WMRibbon >;

  private var __indexes( null, null ):Array< Int >;

  public function new() {
    ribbons = new Array< WMRibbon >();
    coils = new Array< WMRibbon >();
  }

  public function setPositions( pos:Array< Dynamic >,
                                ?ni:Int = 2 ):Void {
    var pa:Array< Dynamic > = new Array< Dynamic >();
    __indexes = new Array< Int >();
    var my_ni:Int = ni + 1;
    for ( p in pos ) {
      my_ni = ni + 1;
      if ( p.n != null && p.n >= 0 ) {
        my_ni = p.n + 1;
        pa.push( { p:Point3D.fromString( p.pos ), n:my_ni, dir:p.dir } );
      } else {
        pa.push( { p:Point3D.fromString( p.pos ), n:-1, dir:p.dir } );
      }
      for ( i in 0 ... my_ni ) __indexes.push( p.index );
    }
    // cut last my_ni - 1 elements ... in ad hoc way ... orz
    for ( i in 0 ... my_ni - 1 ) __indexes.pop();
    chain = new SmoothChain( pa, ni + 1 );
  }

  public function register( r:WMRibbon ):Void {
    var rc:WMRibbon = r.clone();
    var a:Array< Int > = __getIndex( rc.initXML, rc.lastXML );
    if ( a == null ) return; // invalid ribbon/coil. do nothing.
    rc.init = a[0];
    rc.last = a[1];
    if ( rc.isRibbon ) {
      ribbons.push( rc );
    } else {
      coils.push( rc );
    }
  }

  public function gen( c:Context3D ):Void {
    for ( rb in ribbons ) rb.gen( c, chain );
    for ( cl in coils ) cl.gen( c, chain );
  }

  public function draw( c:Context3D,
                        mpos:Matrix3D,
                        proj:Matrix3D,
                        voffset:Vector3D,
                        ?light:Vector3D = null,
                        ?cpos:Vector3D = null ):Void {
    for ( rb in ribbons ) rb.draw( c, mpos, proj, voffset, light, cpos );
    for ( cl in coils ) cl.draw( c, mpos, proj, voffset, light, cpos );
  }

  private function __getIndex( init:Int,
                               last:Int ):Array< Int > {
    var ret:Array< Int > = new Array< Int >();
    var keep:Int = -1;
    // dirty code ... orz
    var flag:Bool = false;
    for ( i in 0 ... __indexes.length ) {
      if ( init == __indexes[i] && !flag ) {
        ret.push( i );
        flag = true;
      }
      if ( last < __indexes[i] && flag ) {
        ret.push( i );
        break;
      }
      if ( last == __indexes[i] && flag ) keep = i + 1;
    }
    if ( ret.length == 1 && keep > 0 ) ret.push( keep );
    if ( ret.length != 2 ) {
      trace( "WMChain::getIndex: unexpected error. Invalid \"init\" and \"last\" are given?" );
      return( null );
    }
    return( ret );
  }

  public function getPositions():Array< Point3D > {
    return( chain.getPositions() );
  }

  public function __getChain():SmoothChain { return( chain ); }
  public function __getRibbons():Array< WMRibbon > { return( ribbons ); }
  public function __getCoils():Array< WMRibbon > { return( coils ); }
}
