/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      MainFrame.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using War02.Core;

namespace War02.animEditor
{
    /**
     * AvP[ṼCt[NX
     * @package War02.animEditor
     */
    public partial class MainFrame : Form
    {
        /**
         * RXgN^
         */
        public MainFrame()
        {
            InitializeComponent();
        }

        /**
         * Ct[̃[hɎs鑀
         */
        private void MainFrame_Load(object sender, EventArgs e)
        {
            initCharAnimTree();
        }


        /**
         * LN^[̃Aj[Vc[
         */
        private void initCharAnimTree()
        {
            ctrlCharAnimTree.Nodes.Clear();

            AnimationGroupCollection groupCollection = AnimationGroupCollection.getInstance();

            ctrlCharAnimTree.addGroup(groupCollection.getGroupById(AnimationGroupID.FACE));
            ctrlCharAnimTree.addGroup(groupCollection.getGroupById(AnimationGroupID.BODY));
            ctrlCharAnimTree.addGroup(groupCollection.getGroupById(AnimationGroupID.WEAPON));
        }


        /**
         * LN^[̃Aj[Vc[̃m[h
         * NbNĂяoCxg
         */
        private void ctrlCharAnimTree_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if(e.Button == MouseButtons.Right)
            {
                //NbN
            }
            else if(e.Button == MouseButtons.Right)
            {
                //ENbN
                e.Node.ContextMenu.Show((Control)sender, new Point(e.X, e.Y));
            }
        }
    }
}