/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      AnimationCollection.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;
using War02.Core;
using GSCommon;

namespace War02.animEditor
{
    /**
     * Aj[Vf[^ǗNX
     */
    class AnimationCollection : IGroupItemCollection
    {
        private Dictionary<Int32, Animation> _dic;
        private Int32 _idSeq;
        private List<IGroupItemListener> _listener;

        /**
         * RXgN^
         */
        public AnimationCollection()
        {
            _idSeq = 1;
            _dic = new Dictionary<Int32, Animation>();
            _listener = new List<IGroupItemListener>();
        }


        /**
         * Aj[Vǉ
         */
        public void add(Animation anim)
        {
            _dic.Add(getNewID(), anim);
        }


        /**
         * VAj[VIDԂ
         */
        private Int32 getNewID()
        {
            return _idSeq++;
        }


        /**
         * w肳ꂽIDIGroupItemԂ
         * @param id ACeID
         * @return ACe
         */
        public IGroupItem getItem(int id)
        {
            Animation anim;
            if(!_dic.TryGetValue(id, out anim))
            {
                //ۂɂ͗O𓊂ׂ
                return null;
            }

            return anim;
        }


        /**
         * IGroupItemLisenero^
         * @param l RNVĎIGroupItemLisener
         */
        public void addGroupItemLisener(IGroupItemListener l)
        {
            if(_listener.Contains(l))
            {
                return;
            }
            _listener.Add(l);
        }


        /**
         * IGroupItemLisener폜
         * @param RNV̊ĎIGroupItemLisener
         */
        public void removeGroupItemLisener(IGroupItemListener l)
        {
            if(!_listener.Contains(l))
            {
                return;
            }
            _listener.Remove(l);
        }
    }
}
