/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      GroupCollection.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;

namespace GSCommon
{


/**
 * O[v̏WNX
 */
class GroupCollection
{

    ///O[ṽXg
    private Dictionary<Int32, Group> _groupList;

    /**
     * RXgN^
     */
    public GroupCollection()
    {
        _groupList = new Dictionary<Int32, Group>();
    }


    /**
     * O[vǉ
     * @param group o^O[v
     */
    public void addGroup(Group group)
    {
        _groupList.Add(group.ID, group);
    }


    /**
     * w肳ꂽID̃O[vԂ
     * @param id O[vID
     * @return O[v
     */
    public Group getGroupById(Int32 id)
    {
        Group group = null;
        if(!_groupList.TryGetValue(id, out group))
        {
            return null;
        }
        return group;
    }


    /**
     * _groupList̃ANZT
     */
    public Dictionary<Int32, Group> groupList
    {
        get { return _groupList; }
    }


    /**
     * O[ṽXgzɊi[ĕԂ
     * @return O[v̔z
     */
    public Group[] getListByArray()
    {
        Group[] arr = new Group[_groupList.Count];

        Int32 i=0;
        foreach(KeyValuePair<Int32, Group> kvp in _groupList)
        {
            arr.SetValue(kvp.Value, i++);
        }
        return arr;
    }


}

}
