/**
 * WAR02 Animation Editor.
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      AnimationGroupList.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;
using GSCommon;


namespace War02.Core
{

/**
 * Aj[VO[vID`NX
 */
class AnimationGroupID
{
    ///̃Aj[VO[vID
    public const Int32 FACE=1;
    ///̂̃Aj[VO[vID
    public const Int32 BODY=2;
    ///̃Aj[VO[vID
    public const Int32 WEAPON=3;
    ///GtFNg̃Aj[VO[vID
    public const Int32 EFFECT=4;
    ///ACẽAj[VO[vID
    public const Int32 ITEM=5;
    ///̑̃Aj[VO[vID
    public const Int32 MISC=6;
}

/**
 * Aj[VO[ṽNX
 * @package War02.Core
 */
class AnimationGroupCollection : GroupCollection
{
    private static AnimationGroupCollection _instance=null;


    /**
     * RXgN^
     */
    private AnimationGroupCollection()
    {
        addGroup(new Group(AnimationGroupID.FACE, ""));
        addGroup(new Group(AnimationGroupID.BODY, ""));
        addGroup(new Group(AnimationGroupID.WEAPON, ""));
        addGroup(new Group(AnimationGroupID.EFFECT, "GtFNg"));
        addGroup(new Group(AnimationGroupID.ITEM, "ACe"));
        addGroup(new Group(AnimationGroupID.MISC, "̑"));
    }


    /**
     * NX̃CX^XԂ
     * @return NX̃CX^X
     */
    public static AnimationGroupCollection getInstance()
    {
        if(_instance == null)
        {
            _instance = new AnimationGroupCollection();
        }
        return _instance;
    }
};

}
