/**
 * GS Common Library
 * Copyright (C)2006  Hiroki.Uematsu
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * @file      IGroupItemCollections.cs
 * @copyright 2006 Hiroki.Uematsu
 * @version   CVS: $Id$
 */

using System;
using System.Collections.Generic;
using System.Text;
using GSCommon;

namespace GSCommon
{
    /**
     * IGroupItemC^[tF[XACe
     * W񂷂NX̃C^[tF[X
     */
    interface IGroupItemCollection
    {
        /**
         * w肵IDɑΉACeԂ
         */
        IGroupItem getItem(Int32 id);

        /**
         * RNV̕ύXĎIuWFNgǉ
         */
        void addGroupItemLisener(IGroupItemListener l);

        /**
         * RNV̕ύXĎIuWFNg폜
         */
        void removeGroupItemLisener(IGroupItemListener l);
    }


    /**
     * RNVNXɋN
     * ύX̏i[IuWFNg
     */
    public class GroupItemChangeEvent
    {
        ///Cxg̔
        private Object _source;
        ///Cxg̎
        private Int32  _eventId;
        ///ω̋NACeID
        private Int32  _itemId;

        /**
         * Cxg̔̃IuWFNgԂ
         */
        public Object Source
        {
            get { return _source; }
        }

        /**
         * CxgIDԂ
         */
        public Int32 EventId
        {
            get { return _eventId; }
        }

        /**
         * ACeIDԂ
         */
        public Int32 ItemId
        {
            get { return _itemId; }
        }
    }


    /**
     * RNVNXɑ΂ύXĎ
     * NX̃C^[tF[X
     */
    interface IGroupItemListener
    {
        /**
         * ύXNƂʒm
         * @param e ύX̏ێIuWFNg
         */
        void updateList(GroupItemChangeEvent e);
    }

}
