#ifndef TYPE_UTILS_H
#define TYPE_UTILS_H

/*!
  \file
  \brief ^`

  \author Saotufmi KAMIMURA

  $Id$
*/

#include <math.h>
#include "math_util.h"


/*!
  \brief r[Sp̖O
*/
namespace VXV {
  /*!
    \brief ʒu̒萔
  */
  enum Align {
    Top = 	0x01,
    Middle = 	0x02,
    Bottom = 	0x04,
    Left = 	0x08,
    Center = 	0x10,
    Right = 	0x20,
  };

  const double DEG2RAD = 2.0 * M_PI / 360.0; /*!< ωZɂ radian ɕϊ */
  const double RAD2DEG = 1.0 / DEG2RAD;	/*!< ωZɂ degree ɕϊ */

  /*!
    \brief 񎟌ʒu
  */
  class Grid {
  public:
    int x;			/*!< Xl */
    int y;			/*!< Yl */

    Grid(void) : x(0), y(0) {};

    /*!
      \brief lw̃RXgN^

      \param x [i] Xl
      \param y [i] Yl
    */
    Grid(int x, int y) : x(x), y(y) {};

    /*!
      \brief Rs[RXgN^
    */
    Grid(const Grid* rhs) : x(rhs->x), y(rhs->y) {}

    virtual ~Grid(void) {}

    /*!
      \brief Zq`
    */
    const Grid& operator+=(const Grid& rhs);

    /*!
      \brief Zq`
    */
    const Grid operator+(const Grid& rhs) const {
      return Grid(this) += rhs;
    }

    /*!
      \brief Zq`
    */
    const Grid& operator-=(const Grid& rhs);

    /*!
      \brief Zq`
    */
    Grid operator-(const Grid& rhs) const {
      return Grid(this) -= rhs;
    }

    /*!
      \brief Zq`
    */
    bool operator==(const Grid& rhs) const {
      return (this->x == rhs.x) && (this->y == rhs.y);
    }
  };


  /*!
    \brief Oʒu
  */
  class Grid3D : public Grid {
  public:
    int z;			/*!< Zl */

    Grid3D(void) : z(0) {};

    /*!
      \brief lw̃RXgN^

      \param x [i] Xl
      \param y [i] Yl
      \param z [i] Zl
    */
    Grid3D(int x, int y, int z) : Grid(x, y), z(z) {};

    /*!
      \brief lw̃RXgN^

      \param x [i] Xl
      \param y [i] Yl
    */
    Grid3D(int x, int y) : Grid(x, y), z(0) {};

    /*!
      \brief Rs[RXgN^
    */
    Grid3D(const Grid3D* rhs) : Grid(rhs->x, rhs->y), z(rhs->z) {}

    /*!
      \brief Rs[RXgN^
    */
    Grid3D(const Grid& rhs) : Grid(rhs.x, rhs.y), z(0) {}

    virtual ~Grid3D(void) {}

    /*!
      \brief Zq`
    */
    const Grid3D& operator+=(const Grid3D& rhs);

    /*!
      \brief Zq`
    */
    const Grid3D operator+(const Grid3D& rhs) const {
      return Grid3D(this) += rhs;
    }

    /*!
      \brief Zq`
    */
    const Grid3D& operator-=(const Grid3D& rhs);

    /*!
      \brief Zq`
    */
    Grid3D operator-(const Grid3D& rhs) const {
      return Grid3D(this) -= rhs;
    }
  };


  /*!
    \brief 
  */
  class Direction {
    double inner_radian;
    Direction(const double radian) : inner_radian(radian) {}

  public:
    Direction(void) : inner_radian(0.0) {}

    /*!
      \brief Ǘ radian lԂ

      \retval Ǘ radian l
    */
    double getInnerRadian(void) const {
      return inner_radian;
    }

    /*!
      \brief Rs[RXgN^
    */
    Direction(const Direction* rhs) : inner_radian(rhs->inner_radian) {}

    virtual ~Direction(void) {}

    /*!
      \brief Zq`
    */
    const Direction& operator+=(const Direction& rhs) {
      inner_radian += rhs.inner_radian;
      return *this;
    }

    /*!
      \brief Zq`
    */
    const Direction operator+(const Direction& rhs) const {
      return Direction(this) += rhs;
    }

    /*!
      \brief Zq`
    */
    bool operator==(const Direction& rhs) const {
      return (this->to_rad() == rhs.to_rad());
    }

    /*!
      \brief Zq`
    */
    const Direction& operator-=(const Direction& rhs) {
      inner_radian -= rhs.inner_radian;
      return *this;
    }

    /*!
      \brief Zq`
    */
    Direction operator-(const Direction& rhs) const {
      return Direction(this) -= rhs;
    }


    /*!
      \brief degreel̊pxi[

      \param degree [i] pxl [degree]
      \retval DirectionIuWFNg
    */
    static Direction deg(int degree) {
      return Direction(2.0 * M_PI * degree / 360.0);
    }

    /*!
      \brief radianl̊pxi[

      \param radian [i] pxl [radian]
      \retval DirectionIuWFNg
    */
    static Direction rad(double radian) {
      return Direction(radian);
    }

    /*!
      \brief degreePʂ̒lԂ

      ԂĺA[+180, -180) ƂȂ

      \retval pxl [degree]
    */
    const int to_deg(void) const;

    /*!
      \brief radianPʂ̒lԂ

      ԂĺA[+M_PI, -M_PI) ƂȂ

      \retval pxl [radian]
    */
    const double to_rad(void) const;
  };


  /*!
    \brief ʒuƋ`TCY
  */
  class Rect : public Grid {
  public:
    int w;			/*!<  */
    int h;			/*!<  */

    Rect(void) : Grid(0, 0), w(0), h(0) {}

    /*!
      \brief lw̃RXgN^
    */
    Rect(int w, int h) : Grid(0, 0), w(w), h(h) {}

    /*!
      \brief lw̃RXgN^
    */
    Rect(int x, int y, int w, int h) : VXV::Grid(x, y), w(w), h(h) {}

    virtual ~Rect(void) {}
  };


  /*!
    \brief ʒuƌ
  */
  class Position : public Grid {
  public:
    Direction zt;			/*!<  */

    Position(void) {}

    /*!
      \brief lw̃RXgN^

      \param x [i] Xl
      \param y [i] Yl
      \param zt [i] IuWFNg
    */
    Position(int x, int y, const Direction& zt) : Grid(x, y), zt(zt) {}

    /*!
      \brief Rs[RXgN^
    */
    Position(const Position* rhs)
      : Grid(rhs->x, rhs->y), zt(rhs->zt) {}

    /*!
      \brief Zq`
    */
    bool operator==(const Position& rhs) const {
      return (this->x == rhs.x) && (this->y == rhs.y) && (this->zt == rhs.zt);
    }

    /*!
      \brief Zq`
    */
    const Position& operator+=(const Position& rhs);

    /*!
      \brief Zq`
    */
    const Position operator+(const Position& rhs) const {
      return Position(this) += rhs;
    }

    /*!
      \brief Zq`
    */
    const Position& operator-=(const Position& rhs);

    /*!
      \brief Zq`
    */
    const Position operator-(const Position& rhs) const {
      return Position(this) -= rhs;
    }

    virtual ~Position(void) {}
  };


  /*!
    \brief Öʒuƌ
  */
  class Position3D : public Position {
  public:
    int z;			/*!< Zl */
    Direction xt;		/*!<  */
    Direction yt;		/*!<  */

    Position3D(void) : z(0), xt(Direction()), yt(Direction()) {}

    /*!
      lw̃RXgN^
      
      \param x [i] Xl
      \param y [i] Yl
      \param z [i] Zl
      \param xt [i] IuWFNg
      \param yt [i] IuWFNg
      \param zt [i] IuWFNg
    */
    Position3D(int x, int y, int z, Direction xt, Direction yt, Direction zt)
      : Position(x, y, zt), z(z), xt(xt), yt(yt) {}

    /*!
      \brief Rs[RXgN^
    */
    Position3D(const Position3D* rhs)
      : Position(rhs->x, rhs->y, rhs->zt),
	z(rhs->z), xt(rhs->xt), yt(rhs->yt) {}

    /*!
      \brief RXgN^
    */
    Position3D(const Position& rhs)
      : Position(rhs),
	z(0), xt(Direction()), yt(Direction()) {}

    /*!
      \brief Zq`
    */
    bool operator==(const Position3D& rhs) const {
      return (this->x == rhs.x) && (this->y == rhs.y) && (this->z == rhs.z) &&
	(this->xt == rhs.xt) && (this->yt == rhs.yt) && (this->zt == rhs.zt);
    }

    /*!
      \brief Zq`
    */
    const Position3D& operator+=(const Position3D& rhs);

    /*!
      \brief Zq`
    */
    const Position3D operator+(const Position3D& rhs) const {
      return Position3D(this) += rhs;
    }

    /*!
      \brief Zq`
    */
    const Position3D& operator-=(const Position3D& rhs);

    /*!
      \brief Zq`
    */
    const Position3D operator-(const Position3D& rhs) const {
      return Position3D(this) -= rhs;
    }

    virtual ~Position3D(void) {}
  };

  /*!
    \brief _Ƃ̋vZ

    \param position [i] ʒu
    \retval  [mm]
  */
  extern int length(const Grid3D& position);


  /*!
    \brief ϊs
  */
  typedef struct {
    double a11;			/*!< svf */
    double a21;			/*!< svf */
    double a31;			/*!< svf */
    double a12;			/*!< svf */
    double a22;			/*!< svf */
    double a32;			/*!< svf */
    double a13;			/*!< svf */
    double a23;			/*!< svf */
    double a33;			/*!< svf */

    int a41;			/*!< svf */
    int a42;			/*!< svf */
    int a43;			/*!< svf */
    int a44;			/*!< svf */
  } Matrix4D;

  /*!
    \brief ϊs̍쐬

    \param pos [i] ϊi[
    \retval ϊs
  */
  extern Matrix4D createConvertMatrix(const Position3D pos);

  /*!
    \brief ʒuϊ

    \param converted [o] ϊ
    \param input [i] ϊ
    \param matrix [i] ϊs
  */
  extern void convert(Position3D& converted, const Position3D& input,
		      const Matrix4D& matrix);

  /*!
    \brief ϊApxZ

    \param converted [o] ϊ
    \param input [i] ϊ
    \param forMatrix [i] ϊs
  */
  extern void convertWithAngle(Position3D& converted, const Position3D& input,
			       const Position3D& forMatrix);
}

#endif /* !TYPE_UTILS_H */
