#ifndef CONNECT_DEVICE_C_H
#define CONNECT_DEVICE_C_H

/*
  ʐM
  Satofumi KAMIMURA
  $Id$
*/

enum {
  TCP_IP = 1,
  SERIAL = 2,

  SCI_TIMEOUT = 105,		/*!< M̃^CAEg */
  DEVICE_OPEN_ERROR = -2,	/*!< foCXoG[ */
  BAUDRATE_ADJUST_ERROR = -3,	/*!< {[[gݒG[ */
  NO_CONNECT = -4,		/*!< ڑG[ */

  ID_MAX = 32,
  BUFFER_SIZE = 4096,
};


#include "cpp_extern_macro.h"
BEGIN_C_DECLS;

extern int initConnectDevice(const char *devName, int baudrate, int mode);
extern void closeDevice(int id);
extern int device_is_connected(int id);
extern int device_send(int id, const char *data, int length);
extern int device_recv(int id, char *data, int size, int timeout);
extern void device_flush(int id);
extern int device_set_baudrate(int id, long baudrate);

END_C_DECLS;
#endif /* !CONNECT_DEVICE_C_H */
