/*
  VXV j^
  Satofumi KAMIMURA
  $Id$
*/

#include "vmonitor.h"
#include "vexception.h"
#include "parseArgs.h"
#include "timeUtils.h"
#include "screenTask.h"
#include "fileUtils.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>


vmonitor* vmonitor::obj = NULL;
std::string vmonitor::ttf_path;


void vmonitor::VMonitorProperty::evaluate(void) {
  const char* home_str = getenv("HOME");
  std::string home_path = std::string((home_str ? home_str : ".")) + "/.vxv";
  value(ttf_file, "ttf_path", (home_path + "/font.ttf").c_str());
  value(urg_type, "urg_type", "URG-04LX");
  value(&crd_index, "crd_index", 0);
}


vmonitor::vmonitor(void)
  : win(NULL), ttf(NULL), task(NULL), scr(NULL),
    task_count(0), mode(Monitor::Unknown), is_pause(false),
    fname(NULL), log(NULL), env(NULL), pause_sem(NULL),
    property(new VMonitorProperty()) {
  atexit(terminate);

  const char* home_str = getenv("HOME");
  std::string home_path = std::string((home_str ? home_str : ".")) + "/.vxv";
  const char* searchPath[] = { ".", home_path.c_str(), NULL };
  property->load("monitorconf", searchPath);

  // monitorconf tHgʒu̓ǂݏo
  const char* dummyPath[] = { "", NULL };
  ttf_path = VXV::searchFile(property->ttf_file.c_str(), dummyPath);
  if (ttf_path.empty() && (ttf_path = searchTTF()).empty()) {
    // !!! monitorconf pXɒu
    fprintf(stderr, "Please edit ttf_path in ~/.vxv/monitorconf\n");
  }
  if (!ttf_path.empty()) {
    property->ttf_file = ttf_path;
  }
}


vmonitor::~vmonitor(void) {
  pause();
  hide();
  task->del(scr);

  delete env;
  env = NULL;

  delete log;
  log = NULL;

  delete scr;
  scr = NULL;

  delete task;
  task = NULL;

  delete ttf;
  ttf = NULL;

  delete win;
  win = NULL;

  SDL_DestroySemaphore(obj->pause_sem);

  // !!! ㏑闝RȂ߁A폜
  // !!! H
  // property->save();

  delete property;
}


void vmonitor::terminate(void) {
  delete obj;
}


vmonitor* vmonitor::getObject(void) {
  if (!obj) {
    obj = new vmonitor();
    obj->win = new SDL_Window();
    obj->win->setTitle("VXV Monitor");
    obj->win->autoHideCursor(3000);
    obj->ttf = new TTF_Draw();
    obj->ttf->load(ttf_path.c_str());
    obj->task = new MonitorTask();
    obj->scr = new ScreenTask(obj->win, obj->ttf);
    obj->task->setScreenObject(obj->scr);
    obj->env = new EnvironmentManage();

    obj->pause_sem = SDL_CreateSemaphore(1);
  }
  return obj;
}


int vmonitor::connect(int argc, char *argv[]) {
  vmonitor* mon = vmonitor::getObject();

  char *logfile = NULL;
  char *envfile = NULL;
  int monitorMode = Monitor::parseArgs(logfile, envfile, argc-1, &argv[1]);
  bool fullscreen = false;
  for (int i = 1; i < argc; ++i) {
    if (!strcmp("-fs", argv[i])) {
      fullscreen = true;
    }
  }
  mon->win->setFullscreen(fullscreen);

  mon->setMonitorMode(monitorMode, logfile);
  mon->env->load(envfile);
  mon->scr->setEnvironment(mon->env->getPolygonsReference());

  return monitorMode;
}


void vmonitor::setMonitorMode(int monitorMode, const char* logfile) {

  if ((monitorMode != Monitor::Unknown) && !log) {
    if (monitorMode != Monitor::RealDevice) {
      VXV::set_MonitorMode(false);
    }
    mode = monitorMode;
    fname = logfile;
    bool write = (mode == Monitor::RealDevice) | (mode == Monitor::Simulator);
    log = new LogCtrl(logfile, write);
  }
}


int vmonitor::getMonitorMode(void) {
  if (obj) {
    return obj->mode;
  } else {
    return Monitor::Unknown;
  }
}


unsigned long vmonitor::getTicks(void) {
  if (obj->mode == Monitor::RealDevice) {
    return VXV::GetTicks();
  } else {
    return obj->task->getTicks();
  }
}


void vmonitor::add(TaskInterface* monitor_task) {
  if (task) {
    task->add(monitor_task);
    ++task_count;
  }
}


void vmonitor::del(TaskInterface* monitor_task) {
  if (task) {
    task->del(monitor_task);
    --task_count;
  }

  // RealDevice ł task o^Ȃ߁AI task_count ōs
  if (task_count <= 0) {
    log->flush();
    hide();
  }
}


void vmonitor::show(void) {
  if (!obj) {
    getObject();
  }
  bool nowPause = obj->is_pause;
  obj->pause();
  obj->win->activate(true);

  obj->scr->show();
  if (!nowPause) {
    obj->start();
  }
}


void vmonitor::hide(void) {
  bool nowPause = obj->is_pause;
  obj->pause();
  if (obj->scr) {
    obj->scr->hide();
  }
  if (obj->win) {
    obj->win->activate(false);
  }
  if (!nowPause) {
    obj->start();
  }
}


void vmonitor::pause(void) {
  if (obj->mode != Monitor::Playback) {
    return;
  }

  if (!obj->is_pause) {
    if (obj->task) {
      obj->task->pause();
    }
    obj->is_pause = true;
  }
}


void vmonitor::start(void) {
  if (obj->is_pause) {
    obj->task->start();
    obj->is_pause = false;
  }
}


void vmonitor::setTimeMagnify(double magnify) {
  if (!obj) {
    getObject();
  }
  if (obj->mode != Monitor::RealDevice) {
    VXV::set_DelayTimeMagnify(magnify);
    obj->task->setTimeMagnify(magnify);
  }
}


void vmonitor::setViewMagnify(double magnify) {
  if (!obj) {
    getObject();
  }
  if (obj->mode != Monitor::RealDevice) {
    obj->scr->updateViewMagnify(magnify);
  }
}


const char* vmonitor::getURGType(void) {
  return property->urg_type.c_str();
}


void vmonitor::clear(unsigned long layer) {
  if (obj) {
    obj->scr->clear(layer);
  }
}


unsigned long vmonitor::drawPoints(const std::vector<VXV::Grid3D>& points,
				   unsigned long color, int r) {
  if (obj) {
    return obj->scr->setPoints(points, color, r);
  }
  return InvalidLayerId;
}


unsigned long vmonitor::drawLine(const VXV::Grid3D& p0, const VXV::Grid3D& p1,
				 unsigned long color) {
  if (obj) {
    return obj->scr->setLine(p0, p1, color);
  }
  return InvalidLayerId;
}


unsigned long vmonitor::drawContLine(const std::deque<VXV::Grid3D>& points,
				     unsigned long color) {
  if (obj) {
    return obj->scr->setContLine(points, color);
  }
  return InvalidLayerId;
}


unsigned long vmonitor::drawCircle(const VXV::Grid& center, int r,
				   unsigned long color) {
  if (!obj || (r <= 0)) {
    return InvalidLayerId;
  }
  return obj->scr->setCircle(center, r, color);
}



unsigned long vmonitor::drawText(const char* text, const VXV::Grid& pos,
				 int pxSize, bool pin, unsigned long color,
				 unsigned long background) {
  if (obj) {
    return obj->scr->setText(text, pos, pxSize, pin, color, background);
  }
  return InvalidLayerId;
}


int vmonitor::printf(const char* fmt, ...) {
  if (obj) {
    va_list ap;
    va_start(ap, fmt);
    int n = obj->scr->consolePrintf(fmt, ap);

    return n;
  }
  return 0;
}


void vmonitor::scrollWithRobot(bool on) {
  if (!obj) {
    getObject();
  }
  obj->scr->scrollWithRobot(on);
}
